/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.javascript.tree.SyntacticEquivalence;
import org.sonar.plugins.javascript.api.JavaScriptCheck;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.expression.AssignmentExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.UnaryExpressionTree;
import org.sonar.plugins.javascript.api.visitors.BaseTreeVisitor;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S2123", name="Values should not be uselessly incremented", priority=Priority.CRITICAL, tags={"bug"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="LOGIC_RELIABILITY")
@SqaleConstantRemediation(value="5min")
public class UselessIncrementCheck
extends BaseTreeVisitor {
    private static final String MESSAGE = "Remove this %s or correct the code not to waste it.";

    public void visitAssignmentExpression(AssignmentExpressionTree assignment) {
        if (assignment.expression().is(new Tree.Kind[]{Tree.Kind.POSTFIX_INCREMENT, Tree.Kind.POSTFIX_DECREMENT})) {
            UnaryExpressionTree postfix = (UnaryExpressionTree)assignment.expression();
            if (SyntacticEquivalence.areEquivalent((Tree)assignment.variable(), (Tree)postfix.expression())) {
                String type = postfix.is(new Tree.Kind[]{Tree.Kind.POSTFIX_INCREMENT}) ? "increment" : "decrement";
                String message = String.format(MESSAGE, type);
                this.getContext().addIssue((JavaScriptCheck)this, (Tree)postfix, message);
            }
        }
        super.visitAssignmentExpression(assignment);
    }
}

