/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.javascript.checks.utils.CheckUtils;
import org.sonar.plugins.javascript.api.symbols.Type;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.expression.CallExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.ExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.MemberExpressionTree;
import org.sonar.plugins.javascript.api.tree.statement.ExpressionStatementTree;
import org.sonar.plugins.javascript.api.visitors.SubscriptionBaseTreeVisitor;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S1154", name="Results of operations on strings should not be ignored", priority=Priority.BLOCKER, tags={"bug"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="INSTRUCTION_RELIABILITY")
@SqaleConstantRemediation(value="20min")
public class UselessStringOperationCheck
extends SubscriptionBaseTreeVisitor {
    private static final String MESSAGE = "%s is an immutable object; you must either store or return the result of the operation.";

    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.EXPRESSION_STATEMENT);
    }

    public void visitNode(Tree tree) {
        MemberExpressionTree memberExpression;
        ExpressionTree callee;
        Tree expression = ((ExpressionStatementTree)tree).expression();
        if (expression.is(new Tree.Kind[]{Tree.Kind.CALL_EXPRESSION}) && (callee = ((CallExpressionTree)expression).callee()).is(new Tree.Kind[]{Tree.Kind.DOT_MEMBER_EXPRESSION}) && (memberExpression = (MemberExpressionTree)callee).object().types().containsOnly(Type.Kind.STRING)) {
            String variableName = CheckUtils.asString((Tree)memberExpression.object());
            this.addIssue(tree, String.format(MESSAGE, variableName));
        }
    }
}

