/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks.utils;

import com.google.common.collect.ImmutableSet;
import java.util.Iterator;
import javax.annotation.Nullable;
import org.sonar.javascript.tree.impl.JavaScriptTree;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.expression.ExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.ParenthesisedExpressionTree;
import org.sonar.plugins.javascript.api.tree.lexical.SyntaxToken;

public class CheckUtils {
    public static final ImmutableSet<Tree.Kind> ASSIGNMENT_EXPRESSION = ImmutableSet.of((Object)Tree.Kind.ASSIGNMENT, (Object)Tree.Kind.MULTIPLY_ASSIGNMENT, (Object)Tree.Kind.DIVIDE_ASSIGNMENT, (Object)Tree.Kind.REMAINDER_ASSIGNMENT, (Object)Tree.Kind.PLUS_ASSIGNMENT, (Object)Tree.Kind.MINUS_ASSIGNMENT, (Object[])new Tree.Kind[]{Tree.Kind.LEFT_SHIFT_ASSIGNMENT, Tree.Kind.RIGHT_SHIFT_ASSIGNMENT, Tree.Kind.UNSIGNED_RIGHT_SHIFT_ASSIGNMENT, Tree.Kind.AND_ASSIGNMENT, Tree.Kind.XOR_ASSIGNMENT, Tree.Kind.OR_ASSIGNMENT});
    public static final ImmutableSet<Tree.Kind> RELATIONAL_EXPRESSION = ImmutableSet.of((Object)Tree.Kind.LESS_THAN, (Object)Tree.Kind.GREATER_THAN, (Object)Tree.Kind.LESS_THAN_OR_EQUAL_TO, (Object)Tree.Kind.GREATER_THAN_OR_EQUAL_TO, (Object)Tree.Kind.INSTANCE_OF, (Object)Tree.Kind.RELATIONAL_IN, (Object[])new Tree.Kind[0]);
    public static final ImmutableSet<Tree.Kind> POSTFIX_EXPRESSION = ImmutableSet.of((Object)Tree.Kind.POSTFIX_INCREMENT, (Object)Tree.Kind.POSTFIX_DECREMENT);
    public static final ImmutableSet<Tree.Kind> PREFIX_EXPRESSION = ImmutableSet.of((Object)Tree.Kind.DELETE, (Object)Tree.Kind.VOID, (Object)Tree.Kind.TYPEOF, (Object)Tree.Kind.PREFIX_INCREMENT, (Object)Tree.Kind.PREFIX_DECREMENT, (Object)Tree.Kind.UNARY_PLUS, (Object[])new Tree.Kind[]{Tree.Kind.UNARY_MINUS, Tree.Kind.BITWISE_COMPLEMENT, Tree.Kind.LOGICAL_COMPLEMENT});
    public static final ImmutableSet<Tree.Kind> EQUALITY_EXPRESSION = ImmutableSet.of((Object)Tree.Kind.EQUAL_TO, (Object)Tree.Kind.NOT_EQUAL_TO, (Object)Tree.Kind.STRICT_EQUAL_TO, (Object)Tree.Kind.STRICT_NOT_EQUAL_TO);
    public static final ImmutableSet<Tree.Kind> ITERATION_STATEMENTS = ImmutableSet.of((Object)Tree.Kind.DO_WHILE_STATEMENT, (Object)Tree.Kind.WHILE_STATEMENT, (Object)Tree.Kind.FOR_IN_STATEMENT, (Object)Tree.Kind.FOR_OF_STATEMENT, (Object)Tree.Kind.FOR_STATEMENT);
    public static final ImmutableSet<Tree.Kind> FUNCTION_NODES = ImmutableSet.of((Object)Tree.Kind.FUNCTION_EXPRESSION, (Object)Tree.Kind.FUNCTION_DECLARATION, (Object)Tree.Kind.METHOD, (Object)Tree.Kind.SET_METHOD, (Object)Tree.Kind.GET_METHOD, (Object)Tree.Kind.GENERATOR_METHOD, (Object[])new Tree.Kind[]{Tree.Kind.GENERATOR_DECLARATION, Tree.Kind.GENERATOR_FUNCTION_EXPRESSION, Tree.Kind.ARROW_FUNCTION});

    private CheckUtils() {
    }

    public static Tree.Kind[] functionNodesArray() {
        return (Tree.Kind[])FUNCTION_NODES.toArray((Object[])new Tree.Kind[FUNCTION_NODES.size()]);
    }

    public static Tree.Kind[] iterationStatementsArray() {
        return (Tree.Kind[])ITERATION_STATEMENTS.toArray((Object[])new Tree.Kind[ITERATION_STATEMENTS.size()]);
    }

    public static String asString(Tree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.TOKEN})) {
            return ((SyntaxToken)tree).text();
        }
        StringBuilder sb = new StringBuilder();
        Iterator treeIterator = ((JavaScriptTree)tree).childrenIterator();
        SyntaxToken prevToken = null;
        while (treeIterator.hasNext()) {
            Tree child = (Tree)treeIterator.next();
            if (child == null) continue;
            CheckUtils.appendChild(sb, prevToken, child);
            prevToken = ((JavaScriptTree)child).getLastToken();
        }
        return sb.toString();
    }

    private static void appendChild(StringBuilder sb, @Nullable SyntaxToken prevToken, Tree child) {
        SyntaxToken firstToken;
        if (prevToken != null && CheckUtils.isSpaceRequired(prevToken, firstToken = ((JavaScriptTree)child).getFirstToken())) {
            sb.append(" ");
        }
        sb.append(CheckUtils.asString(child));
    }

    private static boolean isSpaceRequired(SyntaxToken prevToken, SyntaxToken token) {
        return token.line() > prevToken.line() || prevToken.column() + prevToken.text().length() < token.column();
    }

    public static ExpressionTree removeParenthesis(ExpressionTree expressionTree) {
        if (expressionTree.is(new Tree.Kind[]{Tree.Kind.PARENTHESISED_EXPRESSION})) {
            return CheckUtils.removeParenthesis(((ParenthesisedExpressionTree)expressionTree).expression());
        }
        return expressionTree;
    }
}

