/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.expression.CallExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.DotMemberExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.IdentifierTree;
import org.sonar.plugins.javascript.api.visitors.SubscriptionVisitorCheck;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S2228", name="Console logging should not be used", priority=Priority.MAJOR, tags={"owasp-a6", "security"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="SECURITY_FEATURES")
@SqaleConstantRemediation(value="5min")
public class ConsoleLoggingCheck
extends SubscriptionVisitorCheck {
    private static final String MESSAGE = "Remove this logging statement.";

    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.CALL_EXPRESSION);
    }

    public void visitNode(Tree tree) {
        DotMemberExpressionTree callee;
        CallExpressionTree callExpression = (CallExpressionTree)tree;
        if (callExpression.callee().is(new Tree.Kind[]{Tree.Kind.DOT_MEMBER_EXPRESSION}) && ConsoleLoggingCheck.isCalleeConsoleLogging(callee = (DotMemberExpressionTree)callExpression.callee())) {
            this.addLineIssue(tree, MESSAGE);
        }
    }

    private static boolean isCalleeConsoleLogging(DotMemberExpressionTree callee) {
        return callee.object().is(new Tree.Kind[]{Tree.Kind.IDENTIFIER_REFERENCE}) && "console".equals(((IdentifierTree)callee.object()).name()) && "log".equals(callee.property().name());
    }
}

