/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.SetMultimap;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.javascript.cfg.ControlFlowBlock;
import org.sonar.javascript.cfg.ControlFlowGraph;
import org.sonar.javascript.cfg.ControlFlowNode;
import org.sonar.javascript.tree.symbols.Scope;
import org.sonar.plugins.javascript.api.symbols.Symbol;
import org.sonar.plugins.javascript.api.symbols.Usage;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.declaration.FunctionDeclarationTree;
import org.sonar.plugins.javascript.api.tree.declaration.FunctionTree;
import org.sonar.plugins.javascript.api.tree.declaration.MethodDeclarationTree;
import org.sonar.plugins.javascript.api.tree.expression.ArrowFunctionTree;
import org.sonar.plugins.javascript.api.tree.expression.FunctionExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.IdentifierTree;
import org.sonar.plugins.javascript.api.tree.statement.BlockTree;
import org.sonar.plugins.javascript.api.visitors.DoubleDispatchVisitorCheck;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S1854", name="Dead Stores should be removed", priority=Priority.MAJOR, tags={"bug", "cert", "cwe", "unused"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="DATA_RELIABILITY")
@SqaleConstantRemediation(value="15min")
public class DeadStoreCheck
extends DoubleDispatchVisitorCheck {
    private static final String MESSAGE = "Remove this useless assignment to local variable \"%s\"";

    public void visitFunctionDeclaration(FunctionDeclarationTree tree) {
        this.checkFunction((FunctionTree)tree);
        super.visitFunctionDeclaration(tree);
    }

    public void visitFunctionExpression(FunctionExpressionTree tree) {
        this.checkFunction((FunctionTree)tree);
        super.visitFunctionExpression(tree);
    }

    public void visitMethodDeclaration(MethodDeclarationTree tree) {
        this.checkFunction((FunctionTree)tree);
        super.visitMethodDeclaration(tree);
    }

    public void visitArrowFunction(ArrowFunctionTree tree) {
        this.checkFunction((FunctionTree)tree);
        super.visitArrowFunction(tree);
    }

    private void checkFunction(FunctionTree functionTree) {
        if (!functionTree.body().is(new Tree.Kind[]{Tree.Kind.BLOCK})) {
            return;
        }
        this.checkCFG(ControlFlowGraph.build((BlockTree)((BlockTree)functionTree.body())), functionTree);
    }

    private void checkCFG(ControlFlowGraph cfg, FunctionTree functionTree) {
        Usages usages = new Usages(functionTree);
        HashSet<BlockLiveness> livenesses = new HashSet<BlockLiveness>();
        this.buildUsagesAndLivenesses(cfg, usages, livenesses);
        for (BlockLiveness blockLiveness : livenesses) {
            this.checkBlock(blockLiveness, usages);
        }
        for (Symbol symbol : usages.neverReadSymbols()) {
            for (Usage usage : symbol.usages()) {
                if (!DeadStoreCheck.isWrite(usage)) continue;
                this.addIssue((Tree)usage.identifierTree(), symbol);
            }
        }
    }

    private void checkBlock(BlockLiveness blockLiveness, Usages usages) {
        Set live = blockLiveness.liveOut;
        for (Tree element : Lists.reverse((List)blockLiveness.block.elements())) {
            Usage usage = (Usage)blockLiveness.usageByElement.get(element);
            if (DeadStoreCheck.isWrite(usage)) {
                Symbol symbol = DeadStoreCheck.symbol(usage);
                if (!(live.contains(symbol) || usages.hasUsagesInNestedFunctions(symbol) || usages.isNeverRead(symbol))) {
                    this.addIssue(element, symbol);
                }
                live.remove(symbol);
                continue;
            }
            if (!DeadStoreCheck.isRead(usage)) continue;
            live.add(DeadStoreCheck.symbol(usage));
        }
    }

    private void addIssue(Tree element, Symbol symbol) {
        this.addIssue(element, String.format(MESSAGE, symbol.name()));
    }

    private void buildUsagesAndLivenesses(ControlFlowGraph cfg, Usages usages, Set<BlockLiveness> livenesses) {
        BlockLiveness blockLiveness;
        HashMap<ControlFlowNode, BlockLiveness> livenessPerBlock = new HashMap<ControlFlowNode, BlockLiveness>();
        for (ControlFlowBlock block : cfg.blocks()) {
            blockLiveness = new BlockLiveness(block, usages);
            livenessPerBlock.put((ControlFlowNode)block, blockLiveness);
            livenesses.add(blockLiveness);
        }
        ArrayDeque<ControlFlowNode> queue = new ArrayDeque<ControlFlowNode>(cfg.blocks());
        while (!queue.isEmpty()) {
            ControlFlowBlock block;
            block = (ControlFlowNode)queue.pop();
            blockLiveness = (BlockLiveness)livenessPerBlock.get(block);
            boolean changed = blockLiveness.updateLiveInAndOut(livenessPerBlock);
            if (!changed) continue;
            for (ControlFlowNode predecessor : block.predecessors()) {
                queue.push(predecessor);
            }
        }
    }

    @CheckForNull
    public static Symbol symbol(Usage usage) {
        return usage.identifierTree().symbol();
    }

    private static boolean isRead(Usage usage) {
        if (usage == null) {
            return false;
        }
        return usage.kind() == Usage.Kind.READ || usage.kind() == Usage.Kind.READ_WRITE;
    }

    private static boolean isWrite(Usage usage) {
        if (usage == null) {
            return false;
        }
        return usage.kind() == Usage.Kind.WRITE || usage.kind() == Usage.Kind.DECLARATION_WRITE;
    }

    private class Usages {
        private final Scope functionScope;
        private final Set<Symbol> symbols = new HashSet<Symbol>();
        private final Map<IdentifierTree, Usage> localVariableUsages = new HashMap<IdentifierTree, Usage>();
        private final Set<Symbol> neverReadSymbols = new HashSet<Symbol>();
        private final SetMultimap<Symbol, Usage> usagesInCFG = HashMultimap.create();

        public Usages(FunctionTree function) {
            this.functionScope = DeadStoreCheck.this.getContext().getSymbolModel().getScope((Tree)function);
        }

        public boolean hasUsagesInNestedFunctions(Symbol symbol) {
            return this.usagesInCFG.get((Object)symbol).size() != symbol.usages().size();
        }

        @CheckForNull
        public Usage add(IdentifierTree identifier) {
            this.addSymbol(identifier.symbol());
            Usage usage = this.localVariableUsages.get(identifier);
            if (usage != null) {
                this.usagesInCFG.put((Object)identifier.symbol(), (Object)usage);
            }
            return usage;
        }

        private void addSymbol(@Nullable Symbol symbol) {
            if (symbol == null || this.symbols.contains(symbol)) {
                return;
            }
            this.symbols.add(symbol);
            if (this.isLocalVariable(symbol)) {
                boolean readAtLeastOnce = false;
                for (Usage usage : symbol.usages()) {
                    this.localVariableUsages.put(usage.identifierTree(), usage);
                    if (!DeadStoreCheck.isRead(usage)) continue;
                    readAtLeastOnce = true;
                }
                if (!readAtLeastOnce) {
                    this.neverReadSymbols.add(symbol);
                }
            }
        }

        private boolean isLocalVariable(Symbol symbol) {
            Scope scope = symbol.scope();
            while (!scope.isGlobal()) {
                if (scope.equals(this.functionScope)) {
                    return true;
                }
                scope = scope.outer();
            }
            return false;
        }

        public Set<Symbol> neverReadSymbols() {
            return this.neverReadSymbols;
        }

        public boolean isNeverRead(Symbol symbol) {
            return this.neverReadSymbols.contains(symbol);
        }
    }

    private static class BlockLiveness {
        private final ControlFlowBlock block;
        private final Map<Tree, Usage> usageByElement = new HashMap<Tree, Usage>();
        private final Set<Symbol> liveOut = new HashSet<Symbol>();
        private Set<Symbol> liveIn = new HashSet<Symbol>();

        public BlockLiveness(ControlFlowBlock block, Usages usages) {
            this.block = block;
            for (Tree element : Lists.reverse((List)block.elements())) {
                IdentifierTree identifier;
                Usage usage;
                if (!(element instanceof IdentifierTree) || (usage = usages.add(identifier = (IdentifierTree)element)) == null) continue;
                this.usageByElement.put(element, usage);
            }
        }

        public boolean updateLiveInAndOut(Map<ControlFlowNode, BlockLiveness> livenessPerBlock) {
            this.liveOut.clear();
            for (ControlFlowBlock successor : Iterables.filter((Iterable)this.block.successors(), ControlFlowBlock.class)) {
                this.liveOut.addAll(livenessPerBlock.get((Object)successor).liveIn);
            }
            Set<Symbol> oldIn = this.liveIn;
            this.liveIn = new HashSet<Symbol>(this.liveOut);
            for (Tree element : Lists.reverse((List)this.block.elements())) {
                Usage usage = this.usageByElement.get(element);
                if (DeadStoreCheck.isWrite(usage)) {
                    this.liveIn.remove(DeadStoreCheck.symbol(usage));
                    continue;
                }
                if (!DeadStoreCheck.isRead(usage)) continue;
                this.liveIn.add(DeadStoreCheck.symbol(usage));
            }
            return !oldIn.equals(this.liveIn);
        }
    }
}

