/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import javax.annotation.Nullable;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.expression.BinaryExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.ExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.UnaryExpressionTree;
import org.sonar.plugins.javascript.api.tree.statement.ExpressionStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.ForStatementTree;
import org.sonar.plugins.javascript.api.visitors.DoubleDispatchVisitorCheck;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S881", name="Increment (++) and decrement (--) operators should not be used in a method call or mixed with other operators in an expression", priority=Priority.MAJOR, tags={"cert", "misra"})
@SqaleSubCharacteristic(value="LOGIC_RELIABILITY")
@SqaleConstantRemediation(value="5min")
public class IncrementDecrementInSubExpressionCheck
extends DoubleDispatchVisitorCheck {
    private static final String MESSAGE = "Extract this %s operation into a dedicated statement.";
    private static final Tree.Kind[] INC_DEC_EXPRESSIONS = new Tree.Kind[]{Tree.Kind.PREFIX_DECREMENT, Tree.Kind.PREFIX_INCREMENT, Tree.Kind.POSTFIX_INCREMENT, Tree.Kind.POSTFIX_DECREMENT};

    public void visitExpressionStatement(ExpressionStatementTree tree) {
        if (tree.expression().is(INC_DEC_EXPRESSIONS)) {
            this.scan((Tree)((UnaryExpressionTree)tree.expression()).expression());
        } else {
            this.scan(tree.expression());
        }
    }

    public void visitUnaryExpression(UnaryExpressionTree tree) {
        if (tree.is(INC_DEC_EXPRESSIONS)) {
            this.raiseIssue(tree);
        }
        super.visitUnaryExpression(tree);
    }

    public void visitForStatement(ForStatementTree tree) {
        this.scan(tree.init());
        this.scan((Tree)tree.condition());
        this.scanUpdateClause(tree.update());
        this.scan((Tree)tree.statement());
    }

    private void scanUpdateClause(@Nullable ExpressionTree tree) {
        if (tree != null) {
            if (tree.is(INC_DEC_EXPRESSIONS)) {
                this.scan((Tree)((UnaryExpressionTree)tree).expression());
            } else if (tree.is(new Tree.Kind[]{Tree.Kind.COMMA_OPERATOR})) {
                BinaryExpressionTree expressionList = (BinaryExpressionTree)tree;
                this.scanUpdateClause(expressionList.leftOperand());
                this.scanUpdateClause(expressionList.rightOperand());
            } else {
                this.scan((Tree)tree);
            }
        }
    }

    private void raiseIssue(UnaryExpressionTree tree) {
        String message = String.format(MESSAGE, "++".equals(tree.operator().text()) ? "increment" : "decrement");
        this.addIssue((Tree)tree.operator(), message);
    }
}

