/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import java.util.ArrayList;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.javascript.tree.impl.JavaScriptTree;
import org.sonar.plugins.javascript.api.tree.ModuleTree;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.statement.BlockTree;
import org.sonar.plugins.javascript.api.tree.statement.IfStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.IterationStatementTree;
import org.sonar.plugins.javascript.api.visitors.DoubleDispatchVisitorCheck;
import org.sonar.plugins.javascript.api.visitors.IssueLocation;
import org.sonar.plugins.javascript.api.visitors.PreciseIssue;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S2681", name="Multiline blocks should be enclosed in curly braces", priority=Priority.CRITICAL, tags={"bug", "cwe"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="LOGIC_RELIABILITY")
@SqaleConstantRemediation(value="5min")
public class MultilineBlockCurlyBraceCheck
extends DoubleDispatchVisitorCheck {
    private static final Tree.Kind[] NESTING_STATEMENT_KINDS = new Tree.Kind[]{Tree.Kind.IF_STATEMENT, Tree.Kind.FOR_STATEMENT, Tree.Kind.FOR_IN_STATEMENT, Tree.Kind.FOR_OF_STATEMENT, Tree.Kind.WHILE_STATEMENT};
    public static final String IF_PRIMARY_MESSAGE = "This line will not be executed conditionally; only the first line of this %s-line block will be. The rest will execute unconditionally.";
    public static final String LOOP_PRIMARY_MESSAGE = "This line will not be executed in a loop; only the first line of this %s-line block will be. The rest will execute only once.";
    public static final String IF_SECONDARY_MESSAGE = "not conditionally executed";
    public static final String LOOP_SECONDARY_MESSAGE = "not executed in a loop";

    public void visitModule(ModuleTree module) {
        this.checkStatements(module.items());
        super.visitModule(module);
    }

    public void visitBlock(BlockTree tree) {
        this.checkStatements(tree.statements());
        super.visitBlock(tree);
    }

    private void checkStatements(List<? extends Tree> statements) {
        Tree previous = null;
        int statementIndex = 0;
        for (Tree tree : statements) {
            Tree nestingStatement;
            Tree nestedStatement;
            if (previous != null && previous.is(NESTING_STATEMENT_KINDS) && !(nestedStatement = MultilineBlockCurlyBraceCheck.nestedStatement(nestingStatement = previous)).is(new Tree.Kind[]{Tree.Kind.BLOCK}) && MultilineBlockCurlyBraceCheck.column(nestedStatement) == MultilineBlockCurlyBraceCheck.column(tree) && MultilineBlockCurlyBraceCheck.column(nestingStatement) < MultilineBlockCurlyBraceCheck.column(tree)) {
                this.addIssue(tree, nestingStatement, statements.subList(statementIndex + 1, statements.size()));
            }
            previous = tree;
            ++statementIndex;
        }
    }

    private static Tree nestedStatement(Tree nestingStatement) {
        if (nestingStatement.is(new Tree.Kind[]{Tree.Kind.IF_STATEMENT})) {
            return ((IfStatementTree)nestingStatement).statement();
        }
        return ((IterationStatementTree)nestingStatement).statement();
    }

    private void addIssue(Tree statement, Tree nestingStatement, List<? extends Tree> otherStatements) {
        String primaryMessage = LOOP_PRIMARY_MESSAGE;
        String secondaryMessage = LOOP_SECONDARY_MESSAGE;
        if (nestingStatement.is(new Tree.Kind[]{Tree.Kind.IF_STATEMENT})) {
            primaryMessage = IF_PRIMARY_MESSAGE;
            secondaryMessage = IF_SECONDARY_MESSAGE;
        }
        Tree firstStatementInPseudoBlock = MultilineBlockCurlyBraceCheck.nestedStatement(nestingStatement);
        Tree lastStatementInPseudoBlock = statement;
        ArrayList<IssueLocation> secondaryLocations = new ArrayList<IssueLocation>();
        for (Tree tree : otherStatements) {
            if (MultilineBlockCurlyBraceCheck.column(tree) != MultilineBlockCurlyBraceCheck.column(statement)) break;
            secondaryLocations.add(new IssueLocation(tree, secondaryMessage));
            lastStatementInPseudoBlock = tree;
        }
        int nbLines = MultilineBlockCurlyBraceCheck.line(lastStatementInPseudoBlock) - MultilineBlockCurlyBraceCheck.line(firstStatementInPseudoBlock) + 1;
        PreciseIssue preciseIssue = this.addIssue(statement, String.format(primaryMessage, nbLines));
        for (IssueLocation secondaryLocation : secondaryLocations) {
            preciseIssue.secondary(secondaryLocation);
        }
    }

    private static int column(Tree tree) {
        return ((JavaScriptTree)tree).getFirstToken().column();
    }

    private static int line(Tree tree) {
        return ((JavaScriptTree)tree).getLine();
    }
}

