/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.expression.LiteralTree;
import org.sonar.plugins.javascript.api.visitors.DoubleDispatchVisitorCheck;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="MultilineStringLiterals", name="Multiline string literals should not be used", priority=Priority.MAJOR, tags={"bad-practice"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="INSTRUCTION_RELIABILITY")
@SqaleConstantRemediation(value="5min")
public class MultilineStringLiteralsCheck
extends DoubleDispatchVisitorCheck {
    private static final String MESSAGE = "Use string concatenation rather than line continuation.";

    public void visitLiteral(LiteralTree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.STRING_LITERAL}) && tree.value().contains("\n")) {
            this.addLineIssue((Tree)tree, MESSAGE);
        }
    }
}

