/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.google.common.base.Preconditions;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.javascript.tree.impl.SeparatedList;
import org.sonar.javascript.tree.symbols.type.ObjectType;
import org.sonar.plugins.javascript.api.JavaScriptCheck;
import org.sonar.plugins.javascript.api.tree.ScriptTree;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.declaration.FunctionDeclarationTree;
import org.sonar.plugins.javascript.api.tree.declaration.InitializedBindingElementTree;
import org.sonar.plugins.javascript.api.tree.expression.ArrowFunctionTree;
import org.sonar.plugins.javascript.api.tree.expression.AssignmentExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.CallExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.ExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.FunctionExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.LiteralTree;
import org.sonar.plugins.javascript.api.visitors.DoubleDispatchVisitorCheck;
import org.sonar.plugins.javascript.api.visitors.LineIssue;
import org.sonar.squidbridge.annotations.SqaleLinearWithOffsetRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S2762", name="Selections should be stored", priority=Priority.MAJOR, tags={"jquery", "performance", "user-experience"})
@SqaleSubCharacteristic(value="CPU_EFFICIENCY")
@SqaleLinearWithOffsetRemediation(coeff="1min", offset="2min", effortToFixDescription="number of times selection is re-made.")
public class NotStoredSelectionCheck
extends DoubleDispatchVisitorCheck {
    private static final String MESSAGE = "Selection \"$( %s )\" is made %s times. It should be stored in a variable and reused.";
    private static final int DEFAULT = 2;
    @RuleProperty(key="threshold", description="Number of allowed repetition before triggering an issue", defaultValue="2")
    public int threshold = 2;
    private Deque<List<LiteralTree>> selectors;

    public void visitScript(ScriptTree tree) {
        this.selectors = new ArrayDeque<List<LiteralTree>>();
        this.startScopeBlock();
        super.visitScript(tree);
        this.finishScopeBlock();
    }

    private void finishScopeBlock() {
        this.checkForDuplications(this.selectors.pop());
    }

    private void checkForDuplications(List<LiteralTree> selectors) {
        class Entry {
            private Integer count;
            private LiteralTree literalTree;

            Entry(LiteralTree literalTree) {
                this.literalTree = literalTree;
                this.count = 1;
            }

            void inc() {
                Entry entry = this;
                Integer n = entry.count;
                Integer n2 = entry.count = Integer.valueOf(entry.count + 1);
            }
        }
        HashMap<String, Entry> duplications = new HashMap<String, Entry>();
        for (LiteralTree literal : selectors) {
            String value = literal.value();
            Entry entry = (Entry)duplications.get(value);
            if (entry != null) {
                entry.inc();
                continue;
            }
            duplications.put(value, new Entry(literal));
        }
        for (Entry entry : duplications.values()) {
            if (entry.count <= this.threshold) continue;
            String message = String.format(MESSAGE, entry.literalTree.value(), entry.count);
            this.addIssue(new LineIssue((JavaScriptCheck)this, (Tree)entry.literalTree, message).cost((double)entry.count.intValue() - (double)this.threshold));
        }
    }

    public void visitFunctionDeclaration(FunctionDeclarationTree tree) {
        this.startScopeBlock();
        super.visitFunctionDeclaration(tree);
        this.finishScopeBlock();
    }

    public void visitFunctionExpression(FunctionExpressionTree tree) {
        this.startScopeBlock();
        super.visitFunctionExpression(tree);
        this.finishScopeBlock();
    }

    public void visitArrowFunction(ArrowFunctionTree tree) {
        this.startScopeBlock();
        super.visitArrowFunction(tree);
        this.finishScopeBlock();
    }

    private void startScopeBlock() {
        this.selectors.push(new LinkedList());
    }

    public void visitCallExpression(CallExpressionTree tree) {
        LiteralTree parameter;
        if (tree.types().contains((Object)ObjectType.FrameworkType.JQUERY_SELECTOR_OBJECT) && (parameter = NotStoredSelectionCheck.getSelectorParameter(tree)) != null) {
            List<LiteralTree> currentSelectors = this.selectors.peek();
            currentSelectors.add(parameter);
        }
        super.visitCallExpression(tree);
    }

    private static LiteralTree getSelectorParameter(CallExpressionTree tree) {
        SeparatedList parameters = tree.arguments().parameters();
        if (parameters.size() == 1 && ((Tree)parameters.get(0)).is(new Tree.Kind[]{Tree.Kind.STRING_LITERAL}) && !NotStoredSelectionCheck.isElementCreation((LiteralTree)parameters.get(0))) {
            return (LiteralTree)parameters.get(0);
        }
        return null;
    }

    private static boolean isElementCreation(LiteralTree literalTree) {
        Preconditions.checkArgument((boolean)literalTree.is(new Tree.Kind[]{Tree.Kind.STRING_LITERAL}));
        String value = literalTree.value();
        value = value.substring(1, value.length() - 1);
        return value.startsWith("<") && value.endsWith(">");
    }

    public void visitAssignmentExpression(AssignmentExpressionTree tree) {
        super.visitAssignmentExpression(tree);
        this.lookForException(tree.expression());
    }

    public void visitInitializedBindingElement(InitializedBindingElementTree tree) {
        super.visitInitializedBindingElement(tree);
        this.lookForException(tree.right());
    }

    private void lookForException(ExpressionTree tree) {
        LiteralTree parameter;
        CallExpressionTree callExpressionTree;
        if (tree.is(new Tree.Kind[]{Tree.Kind.CALL_EXPRESSION}) && (callExpressionTree = (CallExpressionTree)tree).types().contains((Object)ObjectType.FrameworkType.JQUERY_SELECTOR_OBJECT) && (parameter = NotStoredSelectionCheck.getSelectorParameter(callExpressionTree)) != null) {
            this.selectors.peek().remove(parameter);
        }
    }
}

