/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.plugins.javascript.api.symbols.Symbol;
import org.sonar.plugins.javascript.api.symbols.Usage;
import org.sonar.plugins.javascript.api.tree.ScriptTree;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.visitors.DoubleDispatchVisitorCheck;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S3353", name="Unchanged variables should be marked \"const\"", priority=Priority.MINOR, tags={"es2015"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="UNDERSTANDABILITY")
@SqaleConstantRemediation(value="2min")
public class UnchangedLetVariableCheck
extends DoubleDispatchVisitorCheck {
    private static final String MESSAGE = "Make \"%s\" \"const\".";

    public void visitScript(ScriptTree tree) {
        for (Symbol letVariableSymbol : this.getContext().getSymbolModel().getSymbols(Symbol.Kind.LET_VARIABLE)) {
            boolean isWritten = false;
            Usage declarationWithInit = null;
            for (Usage usage : letVariableSymbol.usages()) {
                if (usage.kind() == Usage.Kind.DECLARATION_WRITE) {
                    declarationWithInit = usage;
                    continue;
                }
                if (!usage.isWrite()) continue;
                isWritten = true;
            }
            if (declarationWithInit == null || isWritten || letVariableSymbol.usages().size() <= 1) continue;
            this.addIssue((Tree)declarationWithInit.identifierTree(), String.format(MESSAGE, letVariableSymbol.name()));
        }
    }
}

