/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.LinkedList;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.declaration.FunctionDeclarationTree;
import org.sonar.plugins.javascript.api.tree.declaration.MethodDeclarationTree;
import org.sonar.plugins.javascript.api.tree.expression.DotMemberExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.ExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.FunctionExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.IdentifierTree;
import org.sonar.plugins.javascript.api.visitors.SubscriptionVisitorCheck;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S2685", name="\"arguments.caller\" and \"arguments.callee\" should not be used", priority=Priority.CRITICAL, tags={"obsolete"})
@SqaleSubCharacteristic(value="INSTRUCTION_RELIABILITY")
@SqaleConstantRemediation(value="30min")
public class ArgumentsCallerCalleeUsageCheck
extends SubscriptionVisitorCheck {
    private static final String ARGUMENTS = "arguments";
    private static final String CALLER = "caller";
    private static final String CALLEE = "callee";
    LinkedList<String> scope = Lists.newLinkedList();
    private static final Tree.Kind[] FUNCTION_NODES = new Tree.Kind[]{Tree.Kind.FUNCTION_EXPRESSION, Tree.Kind.FUNCTION_DECLARATION, Tree.Kind.GENERATOR_METHOD, Tree.Kind.METHOD, Tree.Kind.GENERATOR_DECLARATION, Tree.Kind.GENERATOR_FUNCTION_EXPRESSION};

    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.builder().add((Object)Tree.Kind.DOT_MEMBER_EXPRESSION).add((Object[])FUNCTION_NODES).build();
    }

    public void visitNode(Tree tree) {
        if (tree.is(FUNCTION_NODES)) {
            IdentifierTree name = this.getFunctionName(tree);
            if (name != null) {
                this.scope.add(name.name());
            }
        } else {
            this.checkExpression((DotMemberExpressionTree)tree);
        }
    }

    private void checkExpression(DotMemberExpressionTree expression) {
        if (!expression.object().is(new Tree.Kind[]{Tree.Kind.IDENTIFIER_REFERENCE}) || !expression.property().is(new Tree.Kind[]{Tree.Kind.IDENTIFIER_NAME})) {
            return;
        }
        String object = ((IdentifierTree)expression.object()).name();
        String property = expression.property().name();
        if (ARGUMENTS.equals(object)) {
            this.checkArgumentsProperty((Tree)expression, property);
        } else if (this.scope.contains(object)) {
            this.checkFunctionsProperty((Tree)expression, object, property);
        }
    }

    private void checkFunctionsProperty(Tree tree, String object, String property) {
        if (CALLER.equals(property)) {
            this.addLineIssue(tree, "Remove this use of \"" + object + ".caller\".");
        } else if (ARGUMENTS.equals(property)) {
            this.addLineIssue(tree, "Remove this use of \"" + object + ".arguments\".");
        }
    }

    private void checkArgumentsProperty(Tree tree, String property) {
        if (CALLER.equals(property)) {
            this.addLineIssue(tree, "Remove this use of \"arguments.caller\".");
        } else if (CALLEE.equals(property)) {
            this.addLineIssue(tree, "Name the enclosing function instead of using the deprecated property \"arguments.callee\".");
        }
    }

    public void leaveNode(Tree tree) {
        if (tree.is(FUNCTION_NODES) && this.getFunctionName(tree) != null) {
            this.scope.removeLast();
        }
    }

    public IdentifierTree getFunctionName(Tree tree) {
        if (tree instanceof FunctionExpressionTree) {
            return ((FunctionExpressionTree)tree).name();
        }
        if (tree instanceof FunctionDeclarationTree) {
            return ((FunctionDeclarationTree)tree).name();
        }
        ExpressionTree name = ((MethodDeclarationTree)tree).name();
        return name.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER_NAME}) ? (IdentifierTree)name : null;
    }
}

