/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.javascript.checks.utils.CheckUtils;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.declaration.InitializedBindingElementTree;
import org.sonar.plugins.javascript.api.tree.declaration.ParameterListTree;
import org.sonar.plugins.javascript.api.tree.expression.UnaryExpressionTree;
import org.sonar.plugins.javascript.api.visitors.DoubleDispatchVisitorCheck;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S3509", name="Default parameters should not cause side effects", priority=Priority.MAJOR, tags={"pitfall", "es2015"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="LOGIC_RELIABILITY")
@SqaleConstantRemediation(value="15min")
public class DefaultParameterSideEffectCheck
extends DoubleDispatchVisitorCheck {
    private static final String MESSAGE = "Remove the side effects from this default assignment of \"%s\".";
    private InitializedBindingElementTree currentParameterWithDefault = null;
    private static final Tree.Kind[] SIDE_EFFECT_KINDS = new Tree.Kind[]{Tree.Kind.PREFIX_DECREMENT, Tree.Kind.POSTFIX_DECREMENT, Tree.Kind.PREFIX_INCREMENT, Tree.Kind.POSTFIX_INCREMENT};

    public void visitParameterList(ParameterListTree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.FORMAL_PARAMETER_LIST})) {
            for (Tree parameter : tree.parameters()) {
                if (!parameter.is(new Tree.Kind[]{Tree.Kind.INITIALIZED_BINDING_ELEMENT})) continue;
                this.currentParameterWithDefault = (InitializedBindingElementTree)parameter;
                this.scan(parameter);
                this.currentParameterWithDefault = null;
            }
        } else {
            super.visitParameterList(tree);
        }
    }

    public void visitUnaryExpression(UnaryExpressionTree tree) {
        if (tree.is(SIDE_EFFECT_KINDS) && this.currentParameterWithDefault != null) {
            this.addIssue((Tree)this.currentParameterWithDefault, String.format(MESSAGE, CheckUtils.asString((Tree)this.currentParameterWithDefault.left())));
            this.currentParameterWithDefault = null;
        }
        super.visitUnaryExpression(tree);
    }
}

