/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.javascript.tree.visitors.CharsetAwareVisitor;
import org.sonar.plugins.javascript.api.JavaScriptCheck;
import org.sonar.plugins.javascript.api.tree.ScriptTree;
import org.sonar.plugins.javascript.api.visitors.DoubleDispatchVisitorCheck;
import org.sonar.plugins.javascript.api.visitors.FileIssue;
import org.sonar.plugins.javascript.api.visitors.Issue;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S1451", name="Copyright and license headers should be defined", priority=Priority.BLOCKER)
@SqaleSubCharacteristic(value="SECURITY_FEATURES")
@SqaleConstantRemediation(value="5min")
public class FileHeaderCheck
extends DoubleDispatchVisitorCheck
implements CharsetAwareVisitor {
    private static final String MESSAGE = "Add or update the header of this file.";
    private static final String DEFAULT_HEADER_FORMAT = "";
    @RuleProperty(key="headerFormat", description="Expected copyright and license header (plain text)", defaultValue="", type="TEXT")
    public String headerFormat = "";
    private Charset charset;
    private String[] expectedLines;

    public void setCharset(Charset charset) {
        this.charset = charset;
    }

    public void visitScript(ScriptTree tree) {
        List lines;
        this.expectedLines = this.headerFormat.split("(?:\r)?\n|\r");
        try {
            lines = Files.readLines((File)this.getContext().getFile(), (Charset)this.charset);
        }
        catch (IOException e) {
            String fileName = this.getContext().getFile().getName();
            throw new IllegalStateException("Unable to execute rule \"S1451\" for file " + fileName, e);
        }
        if (!FileHeaderCheck.matches(this.expectedLines, lines)) {
            this.addIssue((Issue)new FileIssue((JavaScriptCheck)this, MESSAGE));
        }
    }

    private static boolean matches(String[] expectedLines, List<String> lines) {
        boolean result;
        if (expectedLines.length <= lines.size()) {
            result = true;
            Iterator<String> it = lines.iterator();
            for (int i = 0; i < expectedLines.length; ++i) {
                String line = it.next();
                if (line.equals(expectedLines[i])) continue;
                result = false;
                break;
            }
        } else {
            result = false;
        }
        return result;
    }
}

