/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.plugins.javascript.api.JavaScriptCheck;
import org.sonar.plugins.javascript.api.symbols.Type;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.declaration.DefaultExportDeclarationTree;
import org.sonar.plugins.javascript.api.tree.expression.ClassTree;
import org.sonar.plugins.javascript.api.tree.expression.IdentifierTree;
import org.sonar.plugins.javascript.api.visitors.FileIssue;
import org.sonar.plugins.javascript.api.visitors.Issue;
import org.sonar.plugins.javascript.api.visitors.SubscriptionVisitorCheck;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S3317", name="Class names and file names should match", priority=Priority.MAJOR, tags={"es2015", "confusing"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="UNDERSTANDABILITY")
@SqaleConstantRemediation(value="5min")
public class FileNameDiffersFromClassCheck
extends SubscriptionVisitorCheck {
    private static final String MESSAGE = "Rename this file to \"%s\".";
    private boolean isOnlyExport = true;
    private String className = null;

    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.DEFAULT_EXPORT_DECLARATION, (Object)Tree.Kind.NAMESPACE_EXPORT_DECLARATION, (Object)Tree.Kind.NAMED_EXPORT_DECLARATION);
    }

    public void visitNode(Tree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.DEFAULT_EXPORT_DECLARATION})) {
            Tree exported = ((DefaultExportDeclarationTree)tree).object();
            if (exported.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER_REFERENCE})) {
                IdentifierTree identifierTree = (IdentifierTree)exported;
                if (identifierTree.types().contains(Type.Kind.CLASS)) {
                    this.className = identifierTree.name();
                }
            } else if (exported.is(new Tree.Kind[]{Tree.Kind.CLASS_DECLARATION})) {
                this.className = ((ClassTree)exported).name().name();
            }
        } else {
            this.isOnlyExport = false;
        }
    }

    public void leaveFile(Tree scriptTree) {
        String fileName;
        if (this.isOnlyExport && this.className != null && !(fileName = this.getContext().getFile().getName()).equals(this.className + ".js")) {
            this.addIssue((Issue)new FileIssue((JavaScriptCheck)this, String.format(MESSAGE, this.className)));
        }
        this.isOnlyExport = true;
        this.className = null;
    }
}

