/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.javascript.tree.visitors.CharsetAwareVisitor;
import org.sonar.plugins.javascript.api.JavaScriptCheck;
import org.sonar.plugins.javascript.api.tree.ScriptTree;
import org.sonar.plugins.javascript.api.visitors.DoubleDispatchVisitorCheck;
import org.sonar.plugins.javascript.api.visitors.Issue;
import org.sonar.plugins.javascript.api.visitors.LineIssue;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="LineLength", name="Lines should not be too long", priority=Priority.MINOR, tags={"convention"})
@SqaleSubCharacteristic(value="READABILITY")
@SqaleConstantRemediation(value="1min")
public class LineLengthCheck
extends DoubleDispatchVisitorCheck
implements CharsetAwareVisitor {
    private static final String MESSAGE = "Split this %s characters long line (which is greater than %s authorized).";
    private static final int DEFAULT_MAXIMUM_LINE_LENGTH = 80;
    private Charset charset;
    @RuleProperty(key="maximumLineLength", description="The maximum authorized line length.", defaultValue="80")
    public int maximumLineLength = 80;

    public void visitScript(ScriptTree tree) {
        List lines;
        try {
            lines = Files.readLines((File)this.getContext().getFile(), (Charset)this.charset);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        for (int i = 0; i < lines.size(); ++i) {
            int length = ((String)lines.get(i)).length();
            if (length <= this.maximumLineLength) continue;
            this.addIssue((Issue)new LineIssue((JavaScriptCheck)this, i + 1, String.format(MESSAGE, length, this.maximumLineLength)));
        }
    }

    public void setCharset(Charset charset) {
        this.charset = charset;
    }
}

