/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.javascript.tree.impl.JavaScriptTree;
import org.sonar.plugins.javascript.api.symbols.Symbol;
import org.sonar.plugins.javascript.api.symbols.SymbolModel;
import org.sonar.plugins.javascript.api.symbols.Usage;
import org.sonar.plugins.javascript.api.tree.ScriptTree;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.visitors.DoubleDispatchVisitorCheck;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="VariableDeclarationAfterUsage", name="Variables should be declared before they are used", priority=Priority.MAJOR, tags={"pitfall"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="LOGIC_RELIABILITY")
@SqaleConstantRemediation(value="10min")
public class VariableDeclarationAfterUsageCheck
extends DoubleDispatchVisitorCheck {
    private static final String MESSAGE = "Move the declaration of \"%s\" before this usage.";

    public void visitScript(ScriptTree tree) {
        SymbolModel symbolModel = this.getContext().getSymbolModel();
        for (Symbol symbol : symbolModel.getSymbols()) {
            if (!symbol.isVariable()) continue;
            this.visitSymbol(symbol);
        }
    }

    private void visitSymbol(Symbol symbol) {
        LinkedList usages = new LinkedList(symbol.usages());
        if (!usages.isEmpty()) {
            Collections.sort(usages, new LineComparator());
            if (((Usage)usages.get(0)).isDeclaration() || ((Usage)usages.get(0)).kind() == Usage.Kind.LEXICAL_DECLARATION) {
                return;
            }
            for (int i = 1; i < usages.size(); ++i) {
                if (!((Usage)usages.get(i)).isDeclaration()) continue;
                this.addIssue((Tree)((Usage)usages.get(0)).identifierTree(), String.format(MESSAGE, symbol.name())).secondary((Tree)((Usage)usages.get(i)).identifierTree(), "Declaration");
                return;
            }
        }
    }

    private static class LineComparator
    implements Comparator<Usage> {
        private LineComparator() {
        }

        @Override
        public int compare(Usage usage1, Usage usage2) {
            return Integer.compare(LineComparator.getLine(usage1), LineComparator.getLine(usage2));
        }

        private static int getLine(Usage usage) {
            return ((JavaScriptTree)usage.identifierTree()).getLine();
        }
    }
}

