/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import org.sonar.javascript.tree.impl.SeparatedList;
import org.sonar.javascript.tree.symbols.type.FunctionType;
import org.sonar.plugins.javascript.api.symbols.Type;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.expression.ArrayLiteralTree;
import org.sonar.plugins.javascript.api.tree.expression.CallExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.DotMemberExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.ExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.IdentifierTree;
import org.sonar.plugins.javascript.api.tree.expression.NewExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.ParenthesisedExpressionTree;
import org.sonar.plugins.javascript.api.visitors.SubscriptionVisitorCheck;

public abstract class AbstractFunctionSizeCheck
extends SubscriptionVisitorCheck {
    private boolean immediatelyInvokedFunctionExpression = false;
    private boolean amdPattern = false;
    private List<Tree> angularExclusions;

    abstract void checkFunction(Tree var1);

    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.METHOD, (Object)Tree.Kind.GENERATOR_METHOD, (Object)Tree.Kind.GENERATOR_DECLARATION, (Object)Tree.Kind.GENERATOR_FUNCTION_EXPRESSION, (Object)Tree.Kind.FUNCTION_DECLARATION, (Object)Tree.Kind.FUNCTION_EXPRESSION, (Object)Tree.Kind.CALL_EXPRESSION, (Object)Tree.Kind.NEW_EXPRESSION);
    }

    public void visitFile(Tree scriptTree) {
        this.angularExclusions = new ArrayList<Tree>();
    }

    public void visitNode(Tree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.CALL_EXPRESSION})) {
            CallExpressionTree callExpressionTree = (CallExpressionTree)tree;
            this.checkForImmediatelyInvokedFunction(callExpressionTree.callee());
            this.checkForAMDPattern(callExpressionTree);
            this.checkAngularModuleMethodCall(callExpressionTree);
            return;
        }
        if (tree.is(new Tree.Kind[]{Tree.Kind.NEW_EXPRESSION})) {
            if (((NewExpressionTree)tree).arguments() != null) {
                this.checkForImmediatelyInvokedFunction(((NewExpressionTree)tree).expression());
            }
            return;
        }
        if (!(this.immediatelyInvokedFunctionExpression || this.amdPattern || this.angularExclusions.contains(tree))) {
            this.checkFunction(tree);
        }
        this.clearCheckState();
    }

    private void checkForAMDPattern(CallExpressionTree tree) {
        if (tree.callee().is(new Tree.Kind[]{Tree.Kind.IDENTIFIER_REFERENCE}) && "define".equals(((IdentifierTree)tree.callee()).name())) {
            for (Tree parameter : tree.arguments().parameters()) {
                if (!parameter.is(new Tree.Kind[]{Tree.Kind.FUNCTION_EXPRESSION})) continue;
                this.amdPattern = true;
            }
        }
    }

    private void checkForImmediatelyInvokedFunction(ExpressionTree callee) {
        boolean parenthesisedFunctionCallee;
        Tree.Kind[] funcExprKinds = new Tree.Kind[]{Tree.Kind.FUNCTION_EXPRESSION, Tree.Kind.GENERATOR_FUNCTION_EXPRESSION};
        boolean directFunctionCallee = callee.is(funcExprKinds);
        boolean bl = parenthesisedFunctionCallee = callee.is(new Tree.Kind[]{Tree.Kind.PARENTHESISED_EXPRESSION}) && ((ParenthesisedExpressionTree)callee).expression().is(funcExprKinds);
        if (directFunctionCallee || parenthesisedFunctionCallee) {
            this.immediatelyInvokedFunctionExpression = true;
        }
    }

    private void checkAngularModuleMethodCall(CallExpressionTree tree) {
        SeparatedList parameters;
        DotMemberExpressionTree callee;
        if (tree.callee().is(new Tree.Kind[]{Tree.Kind.DOT_MEMBER_EXPRESSION}) && (callee = (DotMemberExpressionTree)tree.callee()).object().types().contains(Type.Kind.ANGULAR_MODULE) && !(parameters = tree.arguments().parameters()).isEmpty()) {
            Tree lastArgument = (Tree)parameters.get(parameters.size() - 1);
            this.checkArrayLiteral(lastArgument);
            this.checkSimpleArgument(lastArgument);
        }
    }

    private void checkArrayLiteral(Tree secondParameter) {
        List elements;
        if (secondParameter.is(new Tree.Kind[]{Tree.Kind.ARRAY_LITERAL}) && !(elements = ((ArrayLiteralTree)secondParameter).elements()).isEmpty()) {
            this.checkSimpleArgument((Tree)elements.get(elements.size() - 1));
        }
    }

    private void checkSimpleArgument(Tree argument) {
        Type functionType;
        if (argument instanceof ExpressionTree && (functionType = ((ExpressionTree)argument).types().getUniqueType(Type.Kind.FUNCTION)) != null) {
            this.angularExclusions.add((Tree)((FunctionType)functionType).functionTree());
        }
    }

    private void clearCheckState() {
        this.immediatelyInvokedFunctionExpression = false;
        this.amdPattern = false;
    }
}

