/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import java.util.Collection;
import java.util.Map;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.javascript.se.SeCheck;
import org.sonar.javascript.se.Truthiness;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S2583", name="Conditions should not unconditionally evaluate to \"true\" or to \"false\"", priority=Priority.CRITICAL, tags={"bug", "cert", "cwe", "misra"})
@SqaleSubCharacteristic(value="LOGIC_RELIABILITY")
@SqaleConstantRemediation(value="15min")
@ActivatedByDefault
public class AlwaysTrueOrFalseConditionCheck
extends SeCheck {
    public void checkConditions(Map<Tree, Collection<Truthiness>> conditions) {
        for (Map.Entry<Tree, Collection<Truthiness>> entry : conditions.entrySet()) {
            Collection<Truthiness> results = entry.getValue();
            if (results.size() != 1 || Truthiness.UNKNOWN.equals((Object)results.iterator().next())) continue;
            String result = Truthiness.TRUTHY.equals((Object)results.iterator().next()) ? "true" : "false";
            this.addIssue(entry.getKey(), String.format("Change this condition so that it does not always evaluate to \"%s\".", result));
        }
    }
}

