/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.google.common.collect.ImmutableList;
import com.sonar.sslr.api.RecognitionException;
import com.sonar.sslr.api.typed.ActionParser;
import java.nio.charset.Charset;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.javascript.parser.JavaScriptParserBuilder;
import org.sonar.javascript.tree.JavaScriptCommentAnalyser;
import org.sonar.javascript.tree.impl.JavaScriptTree;
import org.sonar.javascript.tree.visitors.CharsetAwareVisitor;
import org.sonar.plugins.javascript.api.tree.ScriptTree;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.expression.ExpressionTree;
import org.sonar.plugins.javascript.api.tree.lexical.SyntaxToken;
import org.sonar.plugins.javascript.api.tree.lexical.SyntaxTrivia;
import org.sonar.plugins.javascript.api.tree.statement.ExpressionStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.ReturnStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.ThrowStatementTree;
import org.sonar.plugins.javascript.api.visitors.SubscriptionVisitorCheck;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="CommentedCode", name="Sections of code should not be \"commented out\"", priority=Priority.MAJOR, tags={"misra", "unused"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="UNDERSTANDABILITY")
@SqaleConstantRemediation(value="5min")
public class CommentedCodeCheck
extends SubscriptionVisitorCheck
implements CharsetAwareVisitor {
    private static final String MESSAGE = "Remove this commented out code.";
    private static final JavaScriptCommentAnalyser COMMENT_ANALYSER = new JavaScriptCommentAnalyser();
    private ActionParser<Tree> parser;

    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.TOKEN);
    }

    public void visitNode(Tree tree) {
        SyntaxToken token = (SyntaxToken)tree;
        for (SyntaxTrivia trivia : token.trivias()) {
            if (CommentedCodeCheck.isJsDoc(trivia) || CommentedCodeCheck.isJsLint(trivia) || CommentedCodeCheck.isJsHint(trivia) || CommentedCodeCheck.isGlobals(trivia)) continue;
            this.checkCommentText(trivia);
        }
    }

    private void checkCommentText(SyntaxTrivia trivia) {
        String content = COMMENT_ANALYSER.getContents(trivia.text());
        if (content.endsWith("{")) {
            content = content + "}";
        }
        try {
            ScriptTree parsed = (ScriptTree)this.parser.parse(content);
            if (!CommentedCodeCheck.isExclusion(parsed)) {
                this.addLineIssue((Tree)trivia, MESSAGE);
            }
        }
        catch (RecognitionException recognitionException) {
            // empty catch block
        }
    }

    private static boolean isExclusion(ScriptTree parsed) {
        Tree item;
        if (CommentedCodeCheck.isEmptyScriptTree(parsed)) {
            return true;
        }
        return parsed.items().items().size() == 1 && ((item = (Tree)parsed.items().items().get(0)).is(new Tree.Kind[]{Tree.Kind.LABELLED_STATEMENT}) || CommentedCodeCheck.isExpressionExclusion(item) || CommentedCodeCheck.isReturnThrowExclusion(item) || CommentedCodeCheck.isBreakContinueExclusion(item));
    }

    private static boolean isEmptyScriptTree(ScriptTree parsed) {
        return parsed.items() == null || parsed.items().items().isEmpty();
    }

    private static boolean isReturnThrowExclusion(Tree item) {
        ExpressionTree expression = null;
        if (item.is(new Tree.Kind[]{Tree.Kind.RETURN_STATEMENT})) {
            expression = ((ReturnStatementTree)item).expression();
        } else if (item.is(new Tree.Kind[]{Tree.Kind.THROW_STATEMENT})) {
            expression = ((ThrowStatementTree)item).expression();
        }
        return expression != null && expression.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER_REFERENCE});
    }

    private static boolean isExpressionExclusion(Tree item) {
        ExpressionStatementTree expressionStatement;
        return item.is(new Tree.Kind[]{Tree.Kind.EXPRESSION_STATEMENT}) && ((expressionStatement = (ExpressionStatementTree)item).semicolonToken() == null || expressionStatement.expression().is(new Tree.Kind[]{Tree.Kind.COMMA_OPERATOR}));
    }

    private static boolean isBreakContinueExclusion(Tree item) {
        return item.is(new Tree.Kind[]{Tree.Kind.BREAK_STATEMENT, Tree.Kind.CONTINUE_STATEMENT}) && !CommentedCodeCheck.endsWithSemicolon((JavaScriptTree)item);
    }

    private static boolean endsWithSemicolon(JavaScriptTree item) {
        return ";".equals(item.getLastToken().text());
    }

    private static boolean isJsDoc(SyntaxTrivia trivia) {
        return trivia.text().startsWith("/**");
    }

    private static boolean isJsLint(SyntaxTrivia trivia) {
        return trivia.text().startsWith("/*jslint");
    }

    private static boolean isJsHint(SyntaxTrivia trivia) {
        return trivia.text().startsWith("/*jshint");
    }

    private static boolean isGlobals(SyntaxTrivia trivia) {
        return trivia.text().startsWith("/*global");
    }

    public void setCharset(Charset charset) {
        this.parser = JavaScriptParserBuilder.createParser((Charset)charset);
    }
}

