/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.expression.BinaryExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.ConditionalExpressionTree;
import org.sonar.plugins.javascript.api.tree.lexical.SyntaxToken;
import org.sonar.plugins.javascript.api.visitors.PreciseIssue;
import org.sonar.plugins.javascript.api.visitors.SubscriptionVisitorCheck;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleLinearWithOffsetRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S1067", name="Expressions should not be too complex", priority=Priority.MAJOR, tags={"brain-overload"})
@SqaleSubCharacteristic(value="UNIT_TESTABILITY")
@SqaleLinearWithOffsetRemediation(coeff="1min", offset="5min", effortToFixDescription="per complexity point above the threshold")
@ActivatedByDefault
public class ExpressionComplexityCheck
extends SubscriptionVisitorCheck {
    private static final int DEFAULT = 3;
    private static final String MESSAGE = "Reduce the number of conditional operators (%s) used in the expression (maximum allowed %s).";
    @RuleProperty(description="Maximum number of allowed conditional operators in an expression", defaultValue="3")
    public int max = 3;
    private List<ExpressionComplexity> statementLevel = Lists.newArrayList();
    private static final Tree.Kind[] SCOPES = new Tree.Kind[]{Tree.Kind.FUNCTION_EXPRESSION, Tree.Kind.GENERATOR_FUNCTION_EXPRESSION, Tree.Kind.OBJECT_LITERAL, Tree.Kind.CALL_EXPRESSION, Tree.Kind.JSX_JAVASCRIPT_EXPRESSION};
    private static final Tree.Kind[] CONDITIONAL_EXPRS = new Tree.Kind[]{Tree.Kind.CONDITIONAL_EXPRESSION, Tree.Kind.CONDITIONAL_AND, Tree.Kind.CONDITIONAL_OR};

    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.builder().add((Object[])CONDITIONAL_EXPRS).add((Object[])SCOPES).build();
    }

    public void visitFile(Tree scriptTree) {
        this.statementLevel.clear();
        this.statementLevel.add(new ExpressionComplexity());
    }

    public void visitNode(Tree tree) {
        if (tree.is(CONDITIONAL_EXPRS)) {
            ((ExpressionComplexity)Iterables.getLast(this.statementLevel)).incrementNestedExprLevel();
            ((ExpressionComplexity)Iterables.getLast(this.statementLevel)).addOperator(ExpressionComplexityCheck.getOperatorToken(tree));
        } else if (tree.is(SCOPES)) {
            this.statementLevel.add(new ExpressionComplexity());
        }
    }

    private static SyntaxToken getOperatorToken(Tree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.CONDITIONAL_EXPRESSION})) {
            return ((ConditionalExpressionTree)tree).query();
        }
        if (tree.is(new Tree.Kind[]{Tree.Kind.CONDITIONAL_AND, Tree.Kind.CONDITIONAL_OR})) {
            return ((BinaryExpressionTree)tree).operator();
        }
        throw new IllegalStateException("Cannot get operator for " + tree);
    }

    public void leaveNode(Tree tree) {
        if (tree.is(CONDITIONAL_EXPRS)) {
            ExpressionComplexity currentExpression = (ExpressionComplexity)Iterables.getLast(this.statementLevel);
            currentExpression.decrementNestedExprLevel();
            if (currentExpression.isOnFirstExprLevel()) {
                List<SyntaxToken> complexityOperators = currentExpression.getComplexityOperators();
                if (complexityOperators.size() > this.max) {
                    this.addIssue(tree, complexityOperators);
                }
                currentExpression.resetExpressionComplexityOperators();
            }
        } else if (tree.is(SCOPES)) {
            this.statementLevel.remove(this.statementLevel.size() - 1);
        }
    }

    private void addIssue(Tree expression, List<SyntaxToken> complexityOperators) {
        int complexity = complexityOperators.size();
        String message = String.format(MESSAGE, complexity, this.max);
        PreciseIssue issue = this.addIssue(expression, message);
        for (SyntaxToken complexityOperator : complexityOperators) {
            issue.secondary((Tree)complexityOperator, "+1");
        }
        issue.cost((double)complexity - (double)this.max);
    }

    public static class ExpressionComplexity {
        private int nestedLevel = 0;
        private List<SyntaxToken> operators = new ArrayList<SyntaxToken>();

        public void addOperator(SyntaxToken operator) {
            this.operators.add(operator);
        }

        public void incrementNestedExprLevel() {
            ++this.nestedLevel;
        }

        public void decrementNestedExprLevel() {
            --this.nestedLevel;
        }

        public boolean isOnFirstExprLevel() {
            return this.nestedLevel == 0;
        }

        public List<SyntaxToken> getComplexityOperators() {
            return this.operators;
        }

        public void resetExpressionComplexityOperators() {
            this.operators = new ArrayList<SyntaxToken>();
        }
    }
}

