/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.google.common.base.Preconditions;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.javascript.tree.SyntacticEquivalence;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.expression.AssignmentExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.BinaryExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.ExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.IdentifierTree;
import org.sonar.plugins.javascript.api.tree.expression.LiteralTree;
import org.sonar.plugins.javascript.api.tree.expression.UnaryExpressionTree;
import org.sonar.plugins.javascript.api.tree.statement.ForStatementTree;
import org.sonar.plugins.javascript.api.visitors.DoubleDispatchVisitorCheck;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S2251", name="A \"for\" loop update clause should move the counter in the right direction", priority=Priority.BLOCKER, tags={"bug"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="INSTRUCTION_RELIABILITY")
@SqaleConstantRemediation(value="5min")
public class ForLoopIncrementSignCheck
extends DoubleDispatchVisitorCheck {
    private static final String MESSAGE = "\"%s\" is %s and will never reach \"stop condition\".";

    public void visitForStatement(ForStatementTree forStatement) {
        ExpressionTree condition = forStatement.condition();
        ForLoopIncrement loopIncrement = ForLoopIncrement.findInLoopUpdate(forStatement);
        if (condition == null || loopIncrement == null || !loopIncrement.hasValue()) {
            return;
        }
        this.checkIncrementSign(condition, loopIncrement);
        super.visitForStatement(forStatement);
    }

    private void checkIncrementSign(ExpressionTree condition, ForLoopIncrement loopIncrement) {
        if (condition.is(new Tree.Kind[]{Tree.Kind.GREATER_THAN, Tree.Kind.GREATER_THAN_OR_EQUAL_TO})) {
            BinaryExpressionTree binaryExp = (BinaryExpressionTree)condition;
            if (loopIncrement.hasSameIdentifier(binaryExp.leftOperand())) {
                this.checkNegativeIncrement((Tree)condition, loopIncrement);
            } else if (loopIncrement.hasSameIdentifier(binaryExp.rightOperand())) {
                this.checkPositiveIncrement((Tree)condition, loopIncrement);
            }
        } else if (condition.is(new Tree.Kind[]{Tree.Kind.LESS_THAN, Tree.Kind.LESS_THAN_OR_EQUAL_TO})) {
            BinaryExpressionTree binaryExp = (BinaryExpressionTree)condition;
            if (loopIncrement.hasSameIdentifier(binaryExp.leftOperand())) {
                this.checkPositiveIncrement((Tree)condition, loopIncrement);
            } else if (loopIncrement.hasSameIdentifier(binaryExp.rightOperand())) {
                this.checkNegativeIncrement((Tree)condition, loopIncrement);
            }
        }
    }

    private void checkPositiveIncrement(Tree tree, ForLoopIncrement loopIncrement) {
        if (loopIncrement.value() < 0.0) {
            this.addIssue(tree, loopIncrement, "decremented");
        }
    }

    private void checkNegativeIncrement(Tree tree, ForLoopIncrement loopIncrement) {
        if (loopIncrement.value() > 0.0) {
            this.addIssue(tree, loopIncrement, "incremented");
        }
    }

    private void addIssue(Tree tree, ForLoopIncrement loopIncrement, String adjective) {
        String identifier = loopIncrement.identifier.name();
        String message = String.format(MESSAGE, identifier, adjective);
        this.addLineIssue(tree, message);
    }

    @CheckForNull
    private static Double minus(@Nullable Double nullableNumeric) {
        return nullableNumeric == null ? null : Double.valueOf(-nullableNumeric.doubleValue());
    }

    @CheckForNull
    public static Double numericValue(ExpressionTree expression) {
        if (expression.is(new Tree.Kind[]{Tree.Kind.NUMERIC_LITERAL})) {
            return Double.valueOf(((LiteralTree)expression).value());
        }
        if (expression.is(new Tree.Kind[]{Tree.Kind.UNARY_MINUS, Tree.Kind.UNARY_PLUS})) {
            UnaryExpressionTree unaryExp = (UnaryExpressionTree)expression;
            Double subExpressionIntValue = ForLoopIncrementSignCheck.numericValue(unaryExp.expression());
            return expression.is(new Tree.Kind[]{Tree.Kind.UNARY_MINUS}) ? ForLoopIncrementSignCheck.minus(subExpressionIntValue) : subExpressionIntValue;
        }
        return null;
    }

    private static class ForLoopIncrement {
        private final IdentifierTree identifier;
        private final Double value;

        public ForLoopIncrement(IdentifierTree identifier, @Nullable Double value) {
            this.identifier = identifier;
            this.value = value;
        }

        public boolean hasSameIdentifier(ExpressionTree expression) {
            return SyntacticEquivalence.areEquivalent((Tree)this.identifier, (Tree)expression);
        }

        public boolean hasValue() {
            return this.value != null;
        }

        public double value() {
            Preconditions.checkState((this.value != null ? 1 : 0) != 0, (Object)"This ForLoopIncrement has no value");
            return this.value;
        }

        @CheckForNull
        public static ForLoopIncrement findInLoopUpdate(ForStatementTree forStatement) {
            ForLoopIncrement result = null;
            ExpressionTree expression = forStatement.update();
            if (expression != null) {
                if (expression.is(new Tree.Kind[]{Tree.Kind.POSTFIX_INCREMENT, Tree.Kind.PREFIX_INCREMENT})) {
                    UnaryExpressionTree unaryExp = (UnaryExpressionTree)expression;
                    result = ForLoopIncrement.increment(unaryExp.expression(), 1.0);
                } else if (expression.is(new Tree.Kind[]{Tree.Kind.POSTFIX_DECREMENT, Tree.Kind.PREFIX_DECREMENT})) {
                    UnaryExpressionTree unaryExp = (UnaryExpressionTree)expression;
                    result = ForLoopIncrement.increment(unaryExp.expression(), -1.0);
                } else if (expression.is(new Tree.Kind[]{Tree.Kind.PLUS_ASSIGNMENT})) {
                    AssignmentExpressionTree assignmentExp = (AssignmentExpressionTree)expression;
                    result = ForLoopIncrement.increment(assignmentExp.variable(), ForLoopIncrementSignCheck.numericValue(assignmentExp.expression()));
                } else if (expression.is(new Tree.Kind[]{Tree.Kind.MINUS_ASSIGNMENT})) {
                    AssignmentExpressionTree assignmentExp = (AssignmentExpressionTree)expression;
                    result = ForLoopIncrement.increment(assignmentExp.variable(), ForLoopIncrementSignCheck.minus(ForLoopIncrementSignCheck.numericValue(assignmentExp.expression())));
                } else if (expression.is(new Tree.Kind[]{Tree.Kind.ASSIGNMENT})) {
                    AssignmentExpressionTree assignment = (AssignmentExpressionTree)expression;
                    result = ForLoopIncrement.assignmentIncrement(assignment);
                }
            }
            return result;
        }

        @CheckForNull
        private static ForLoopIncrement increment(ExpressionTree expression, Double value) {
            if (expression.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER_REFERENCE})) {
                return new ForLoopIncrement((IdentifierTree)expression, value);
            }
            return null;
        }

        private static ForLoopIncrement assignmentIncrement(AssignmentExpressionTree assignmentExpression) {
            ExpressionTree expression = assignmentExpression.expression();
            ExpressionTree variable = assignmentExpression.variable();
            if (variable.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER_REFERENCE}) && expression.is(new Tree.Kind[]{Tree.Kind.PLUS, Tree.Kind.MINUS})) {
                BinaryExpressionTree binaryExp = (BinaryExpressionTree)expression;
                Double increment = ForLoopIncrementSignCheck.numericValue(binaryExp.rightOperand());
                if (increment != null && SyntacticEquivalence.areEquivalent((Tree)variable, (Tree)binaryExp.leftOperand())) {
                    increment = expression.is(new Tree.Kind[]{Tree.Kind.MINUS}) ? ForLoopIncrementSignCheck.minus(increment) : increment;
                    return ForLoopIncrement.increment(variable, increment);
                }
                return new ForLoopIncrement((IdentifierTree)variable, null);
            }
            return null;
        }
    }
}

