/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.javascript.checks.AbstractFunctionSizeCheck;
import org.sonar.javascript.metrics.ComplexityVisitor;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.declaration.FunctionDeclarationTree;
import org.sonar.plugins.javascript.api.visitors.PreciseIssue;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleLinearWithOffsetRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="FunctionComplexity", name="Functions should not be too complex", priority=Priority.MAJOR, tags={"brain-overload"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="UNIT_TESTABILITY")
@SqaleLinearWithOffsetRemediation(coeff="1min", offset="10min", effortToFixDescription="per complexity point above the threshold")
public class FunctionComplexityCheck
extends AbstractFunctionSizeCheck {
    private static final String MESSAGE = "Function has a complexity of %s which is greater than %s authorized.";
    private static final int DEFAULT_MAXIMUM_FUNCTION_COMPLEXITY_THRESHOLD = 10;
    @RuleProperty(key="maximumFunctionComplexityThreshold", description="The maximum authorized complexity in function", defaultValue="10")
    private int maximumFunctionComplexityThreshold = 10;

    @Override
    void checkFunction(Tree functionTree) {
        List complexityTrees = new ComplexityVisitor().complexityTrees(functionTree);
        if (complexityTrees.size() > this.maximumFunctionComplexityThreshold) {
            this.raiseIssue(functionTree, complexityTrees);
        }
    }

    private void raiseIssue(Tree tree, List<Tree> complexityTrees) {
        int complexity = complexityTrees.size();
        String message = String.format(MESSAGE, complexity, this.maximumFunctionComplexityThreshold);
        Tree primaryLocationTree = complexityTrees.get(0);
        if (tree.is(new Tree.Kind[]{Tree.Kind.FUNCTION_DECLARATION})) {
            primaryLocationTree = ((FunctionDeclarationTree)tree).name();
        }
        PreciseIssue issue = this.addIssue(primaryLocationTree, message);
        for (Tree complexityTree : complexityTrees) {
            issue.secondary(complexityTree, "+1");
        }
        issue.cost((double)complexity - (double)this.maximumFunctionComplexityThreshold);
    }

    public void setMaximumFunctionComplexityThreshold(int threshold) {
        this.maximumFunctionComplexityThreshold = threshold;
    }
}

