/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.javascript.tree.impl.statement.IfStatementTreeImpl;
import org.sonar.plugins.javascript.api.tree.ScriptTree;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.statement.DoWhileStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.ElseClauseTree;
import org.sonar.plugins.javascript.api.tree.statement.ForObjectStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.ForStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.IfStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.SwitchStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.TryStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.WhileStatementTree;
import org.sonar.plugins.javascript.api.visitors.DoubleDispatchVisitorCheck;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="NestedIfDepth", name="Control flow statements \"if\", \"for\", \"while\", \"switch\" and \"try\" should not be nested too deeply", priority=Priority.MAJOR, tags={"brain-overload"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="LOGIC_CHANGEABILITY")
@SqaleConstantRemediation(value="10min")
public class NestedControlFlowDepthCheck
extends DoubleDispatchVisitorCheck {
    private static final String MESSAGE = "Refactor this code to not nest more than %s if/for/while/switch/try statements.";
    private static final int DEFAULT_MAXIMUM_NESTING_LEVEL = 3;
    private int nestedLevel;
    @RuleProperty(key="maximumNestingLevel", description="Maximum allowed \"if/for/while/switch/try\" statements nesting depth", defaultValue="3")
    public int maximumNestingLevel = 3;

    public int getMaximumNestingLevel() {
        return this.maximumNestingLevel;
    }

    public void visitScript(ScriptTree tree) {
        this.nestedLevel = 0;
        super.visitScript(tree);
    }

    public void visitIfStatement(IfStatementTree tree) {
        ++this.nestedLevel;
        this.checkNestedLevel((Tree)tree);
        this.visitIf(tree);
        --this.nestedLevel;
    }

    public void visitForStatement(ForStatementTree tree) {
        ++this.nestedLevel;
        this.checkNestedLevel((Tree)tree);
        super.visitForStatement(tree);
        --this.nestedLevel;
    }

    public void visitForObjectStatement(ForObjectStatementTree tree) {
        ++this.nestedLevel;
        this.checkNestedLevel((Tree)tree);
        super.visitForObjectStatement(tree);
        --this.nestedLevel;
    }

    public void visitWhileStatement(WhileStatementTree tree) {
        ++this.nestedLevel;
        this.checkNestedLevel((Tree)tree);
        super.visitWhileStatement(tree);
        --this.nestedLevel;
    }

    public void visitDoWhileStatement(DoWhileStatementTree tree) {
        ++this.nestedLevel;
        this.checkNestedLevel((Tree)tree);
        super.visitDoWhileStatement(tree);
        --this.nestedLevel;
    }

    public void visitSwitchStatement(SwitchStatementTree tree) {
        ++this.nestedLevel;
        this.checkNestedLevel((Tree)tree);
        super.visitSwitchStatement(tree);
        --this.nestedLevel;
    }

    public void visitTryStatement(TryStatementTree tree) {
        ++this.nestedLevel;
        this.checkNestedLevel((Tree)tree);
        super.visitTryStatement(tree);
        --this.nestedLevel;
    }

    private void checkNestedLevel(Tree tree) {
        if (this.nestedLevel == this.getMaximumNestingLevel() + 1) {
            this.addLineIssue(tree, String.format(MESSAGE, this.getMaximumNestingLevel()));
        }
    }

    private void visitIf(IfStatementTree tree) {
        this.scan((Tree)tree.condition());
        this.scan((Tree)tree.statement());
        ElseClauseTree elseClauseTree = tree.elseClause();
        if (tree.elseClause() != null && elseClauseTree.statement().is(new Tree.Kind[]{Tree.Kind.IF_STATEMENT})) {
            this.visitIf((IfStatementTree)((IfStatementTreeImpl)tree.elseClause().statement()));
        } else {
            this.scan((Tree)tree.elseClause());
        }
    }
}

