/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.google.common.collect.Iterables;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.statement.SwitchClauseTree;
import org.sonar.plugins.javascript.api.tree.statement.SwitchStatementTree;
import org.sonar.plugins.javascript.api.visitors.DoubleDispatchVisitorCheck;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="SwitchWithoutDefault", name="\"switch\" statements should end with a \"default\" clause", priority=Priority.MAJOR, tags={"cert", "cwe", "misra"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="LOGIC_RELIABILITY")
@SqaleConstantRemediation(value="5min")
public class SwitchWithoutDefaultCheck
extends DoubleDispatchVisitorCheck {
    private static final String ADD_DEFAULT_MESSAGE = "Add a \"default\" clause to this \"switch\" statement.";
    private static final String MOVE_DEFAULT_MESSAGE = "Move this \"default\" clause to the end of this \"switch\" statement.";

    public void visitSwitchStatement(SwitchStatementTree tree) {
        if (!SwitchWithoutDefaultCheck.hasDefaultCase(tree)) {
            this.addLineIssue((Tree)tree, ADD_DEFAULT_MESSAGE);
        } else if (!((SwitchClauseTree)Iterables.getLast((Iterable)tree.cases())).is(new Tree.Kind[]{Tree.Kind.DEFAULT_CLAUSE})) {
            this.addLineIssue((Tree)tree, MOVE_DEFAULT_MESSAGE);
        }
        super.visitSwitchStatement(tree);
    }

    private static boolean hasDefaultCase(SwitchStatementTree switchStmt) {
        for (SwitchClauseTree clause : switchStmt.cases()) {
            if (!clause.is(new Tree.Kind[]{Tree.Kind.DEFAULT_CLAUSE})) continue;
            return true;
        }
        return false;
    }
}

