/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import java.util.Iterator;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.javascript.checks.AbstractFunctionSizeCheck;
import org.sonar.javascript.tree.impl.JavaScriptTree;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.statement.BlockTree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S138", name="Functions should not have too many lines", priority=Priority.MAJOR, tags={"brain-overload"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="UNDERSTANDABILITY")
@SqaleConstantRemediation(value="20min")
public class TooManyLinesInFunctionCheck
extends AbstractFunctionSizeCheck {
    private static final String MESSAGE = "This function has %s lines, which is greater than the %s lines authorized. Split it into smaller functions.";
    private static final int DEFAULT = 100;
    @RuleProperty(key="max", description="Maximum authorized lines in a function", defaultValue="100")
    public int max = 100;

    public static int getNumberOfLine(Tree tree) {
        Iterator childrenIterator = ((JavaScriptTree)tree).childrenIterator();
        while (childrenIterator.hasNext()) {
            Tree child = (Tree)childrenIterator.next();
            if (child == null || !child.is(new Tree.Kind[]{Tree.Kind.BLOCK})) continue;
            int firstLine = ((BlockTree)child).openCurlyBrace().line();
            int lastLine = ((BlockTree)child).closeCurlyBrace().line();
            return lastLine - firstLine + 1;
        }
        throw new IllegalStateException("No block child found for current tree.");
    }

    @Override
    void checkFunction(Tree functionTree) {
        int nbLines = TooManyLinesInFunctionCheck.getNumberOfLine(functionTree);
        if (nbLines > this.max) {
            String message = String.format(MESSAGE, nbLines, this.max);
            this.addLineIssue(functionTree, message);
        }
    }
}

