/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.javascript.tree.impl.statement.VariableDeclarationTreeImpl;
import org.sonar.plugins.javascript.api.symbols.Symbol;
import org.sonar.plugins.javascript.api.symbols.Usage;
import org.sonar.plugins.javascript.api.tree.ScriptTree;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.expression.IdentifierTree;
import org.sonar.plugins.javascript.api.tree.statement.ForStatementTree;
import org.sonar.plugins.javascript.api.visitors.DoubleDispatchVisitorCheck;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S3353", name="Unchanged variables should be marked \"const\"", priority=Priority.MINOR, tags={"es2015"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="UNDERSTANDABILITY")
@SqaleConstantRemediation(value="2min")
public class UnchangedLetVariableCheck
extends DoubleDispatchVisitorCheck {
    private static final String MESSAGE = "Make \"%s\" \"const\".";
    private Set<Symbol> createdInForInit;

    public void visitScript(ScriptTree tree) {
        this.createdInForInit = new HashSet<Symbol>();
        super.visitScript(tree);
        for (Symbol letVariableSymbol : this.getContext().getSymbolModel().getSymbols(Symbol.Kind.LET_VARIABLE)) {
            if (this.createdInForInit.contains(letVariableSymbol)) continue;
            boolean isWritten = false;
            Usage declarationWithInit = null;
            for (Usage usage : letVariableSymbol.usages()) {
                if (usage.kind() == Usage.Kind.DECLARATION_WRITE) {
                    declarationWithInit = usage;
                    continue;
                }
                if (!usage.isWrite()) continue;
                isWritten = true;
            }
            if (declarationWithInit == null || isWritten || letVariableSymbol.usages().size() <= 1) continue;
            this.addIssue((Tree)declarationWithInit.identifierTree(), String.format(MESSAGE, letVariableSymbol.name()));
        }
    }

    public void visitForStatement(ForStatementTree tree) {
        List identifiers;
        Tree init = tree.init();
        if (init != null && init.is(new Tree.Kind[]{Tree.Kind.LET_DECLARATION}) && (identifiers = ((VariableDeclarationTreeImpl)init).variableIdentifiers()).size() > 1) {
            for (IdentifierTree identifier : identifiers) {
                this.createdInForInit.add(identifier.symbol());
            }
        }
        super.visitForStatement(tree);
    }
}

