/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.expression.ExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.IdentifierTree;
import org.sonar.plugins.javascript.api.tree.expression.NewExpressionTree;
import org.sonar.plugins.javascript.api.visitors.DoubleDispatchVisitorCheck;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;

@Rule(key="ArrayAndObjectConstructors", name="Array and Object constructors should not be used", priority=Priority.MAJOR, tags={"bug"})
@ActivatedByDefault
@SqaleConstantRemediation(value="5min")
public class ArrayAndObjectConstructorsCheck
extends DoubleDispatchVisitorCheck {
    private static final String MESSAGE = "Use a literal instead of the %s constructor.";

    public void visitNewExpression(NewExpressionTree tree) {
        String next;
        ExpressionTree expression = tree.expression();
        if (expression.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER_REFERENCE}) && ("Array".equals(next = ((IdentifierTree)expression).name()) || "Object".equals(next))) {
            this.addIssue((Tree)tree, String.format(MESSAGE, next));
        }
        super.visitNewExpression(tree);
    }
}

