/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.javascript.checks.utils.CheckUtils;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.expression.BinaryExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.ExpressionTree;
import org.sonar.plugins.javascript.api.tree.statement.CaseClauseTree;
import org.sonar.plugins.javascript.api.visitors.DoubleDispatchVisitorCheck;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;

@Rule(key="S3616", name="Comma operators should not be used in switch cases", priority=Priority.CRITICAL, tags={"bug"})
@ActivatedByDefault
@SqaleConstantRemediation(value="5min")
public class CommaOperatorInSwitchCaseCheck
extends DoubleDispatchVisitorCheck {
    private static final String MESSAGE = "Explicitly specify %d separate cases that fall through; currently this case clause only works for \"%s\".";

    public void visitCaseClause(CaseClauseTree tree) {
        ExpressionTree expression = tree.expression();
        if (expression.is(new Tree.Kind[]{Tree.Kind.COMMA_OPERATOR})) {
            int nbCommas = CommaOperatorInSwitchCaseCheck.getNumberOfCommas(expression);
            ExpressionTree rightOperand = ((BinaryExpressionTree)expression).rightOperand();
            String lastCase = CheckUtils.asString((Tree)rightOperand);
            String msg = String.format(MESSAGE, nbCommas + 1, lastCase);
            this.addIssue((Tree)expression, msg);
        }
        super.visitCaseClause(tree);
    }

    private static int getNumberOfCommas(ExpressionTree expression) {
        int nbCommas = 0;
        if (expression.is(new Tree.Kind[]{Tree.Kind.COMMA_OPERATOR})) {
            BinaryExpressionTree binaryExpression = (BinaryExpressionTree)expression;
            nbCommas = CommaOperatorInSwitchCaseCheck.getNumberOfCommas(binaryExpression.leftOperand()) + 1;
        }
        return nbCommas;
    }
}

