/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import javax.annotation.Nullable;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.plugins.javascript.api.JavaScriptCheck;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.declaration.ParameterListTree;
import org.sonar.plugins.javascript.api.tree.expression.CallExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.ExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.IdentifierTree;
import org.sonar.plugins.javascript.api.tree.expression.NewExpressionTree;
import org.sonar.plugins.javascript.api.visitors.DoubleDispatchVisitorCheck;
import org.sonar.plugins.javascript.api.visitors.Issue;
import org.sonar.plugins.javascript.api.visitors.IssueLocation;
import org.sonar.plugins.javascript.api.visitors.PreciseIssue;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;

@Rule(key="S3523", name="Function constructors should not be used", priority=Priority.CRITICAL, tags={"clumsy", "security"})
@ActivatedByDefault
@SqaleConstantRemediation(value="5min")
public class FunctionConstructorCheck
extends DoubleDispatchVisitorCheck {
    private static final String MESSAGE = "Declare this function instead of using the \"Function\" constructor.";

    public void visitNewExpression(NewExpressionTree tree) {
        if (FunctionConstructorCheck.isNonEmptyFunctionConstructor(tree.expression(), tree.arguments())) {
            this.addIssue((Issue)new PreciseIssue((JavaScriptCheck)this, new IssueLocation((Tree)tree.newKeyword(), (Tree)tree.expression(), MESSAGE)));
        }
        super.visitNewExpression(tree);
    }

    public void visitCallExpression(CallExpressionTree tree) {
        if (FunctionConstructorCheck.isNonEmptyFunctionConstructor(tree.callee(), tree.arguments())) {
            this.addIssue((Tree)tree.callee(), MESSAGE);
        }
        super.visitCallExpression(tree);
    }

    private static boolean isNonEmptyFunctionConstructor(ExpressionTree tree, @Nullable ParameterListTree arguments) {
        boolean result = false;
        if (tree.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER_REFERENCE})) {
            String name = ((IdentifierTree)tree).name();
            result = "Function".equals(name) && arguments != null && !arguments.parameters().isEmpty();
        }
        return result;
    }
}

