/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.javascript.checks.AbstractFunctionSizeCheck;
import org.sonar.javascript.tree.impl.JavaScriptTree;
import org.sonar.plugins.javascript.api.JavaScriptCheck;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.declaration.FunctionTree;
import org.sonar.plugins.javascript.api.visitors.Issue;
import org.sonar.plugins.javascript.api.visitors.IssueLocation;
import org.sonar.plugins.javascript.api.visitors.PreciseIssue;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;

@Rule(key="S138", name="Functions should not have too many lines", priority=Priority.MAJOR, tags={"brain-overload"})
@ActivatedByDefault
@SqaleConstantRemediation(value="20min")
public class TooManyLinesInFunctionCheck
extends AbstractFunctionSizeCheck {
    private static final String MESSAGE = "This function has %s lines, which is greater than the %s lines authorized. Split it into smaller functions.";
    private static final int DEFAULT = 100;
    @RuleProperty(key="max", description="Maximum authorized lines in a function", defaultValue="100")
    public int max = 100;

    @Override
    void checkFunction(FunctionTree functionTree) {
        JavaScriptTree body = (JavaScriptTree)functionTree.body();
        int firstLine = body.getLine();
        int lastLine = body.getLastToken().endLine();
        int nbLines = lastLine - firstLine + 1;
        if (nbLines > this.max) {
            String message = String.format(MESSAGE, nbLines, this.max);
            IssueLocation primaryLocation = new IssueLocation((Tree)((JavaScriptTree)functionTree).getFirstToken(), functionTree.parameterClause(), message);
            this.addIssue((Issue)new PreciseIssue((JavaScriptCheck)this, primaryLocation));
        }
    }
}

