/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import java.util.Collection;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.javascript.tree.symbols.type.FunctionType;
import org.sonar.plugins.javascript.api.symbols.Symbol;
import org.sonar.plugins.javascript.api.symbols.SymbolModel;
import org.sonar.plugins.javascript.api.symbols.Type;
import org.sonar.plugins.javascript.api.symbols.Usage;
import org.sonar.plugins.javascript.api.tree.ScriptTree;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.visitors.DoubleDispatchVisitorCheck;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;

@Rule(key="UnusedVariable", name="Unused local variables and functions should be removed", priority=Priority.MAJOR, tags={"unused"})
@ActivatedByDefault
@SqaleConstantRemediation(value="5min")
public class UnusedVariableCheck
extends DoubleDispatchVisitorCheck {
    private static final String MESSAGE_FOR_VARIABLE = "Remove the declaration of the unused '%s' variable.";
    private static final String MESSAGE_FOR_FUNCTION = "Remove unused function '%s'.";

    public void visitScript(ScriptTree tree) {
        SymbolModel symbolModel = this.getContext().getSymbolModel();
        for (Symbol symbol : symbolModel.getSymbols()) {
            Collection usages;
            FunctionType functionType = (FunctionType)symbol.types().getUniqueType(Type.Kind.FUNCTION);
            if (functionType != null && symbol.is(Symbol.Kind.FUNCTION) && functionType.functionTree().is(new Tree.Kind[]{Tree.Kind.FUNCTION_EXPRESSION, Tree.Kind.GENERATOR_FUNCTION_EXPRESSION}) || !UnusedVariableCheck.noUsages(usages = symbol.usages()) || UnusedVariableCheck.isGlobalOrCatchVariable(symbol) || symbol.builtIn()) continue;
            if (symbol.isVariable()) {
                this.raiseIssuesOnDeclarations(symbol, String.format(MESSAGE_FOR_VARIABLE, symbol.name()));
                continue;
            }
            if (!symbol.is(Symbol.Kind.FUNCTION)) continue;
            this.raiseIssuesOnDeclarations(symbol, String.format(MESSAGE_FOR_FUNCTION, symbol.name()));
        }
    }

    private void raiseIssuesOnDeclarations(Symbol symbol, String message) {
        for (Usage usage : symbol.usages()) {
            if (!usage.isDeclaration()) continue;
            this.addIssue((Tree)usage.identifierTree(), message);
        }
    }

    private static boolean noUsages(Collection<Usage> usages) {
        return usages.isEmpty() || UnusedVariableCheck.usagesAreInitializations(usages);
    }

    private static boolean usagesAreInitializations(Collection<Usage> usages) {
        for (Usage usage : usages) {
            if (usage.isDeclaration()) continue;
            return false;
        }
        return true;
    }

    private static boolean isGlobalOrCatchVariable(Symbol symbol) {
        return symbol.scope().tree().is(new Tree.Kind[]{Tree.Kind.SCRIPT, Tree.Kind.CATCH_BLOCK});
    }
}

