/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.javascript.checks.utils.CheckUtils;
import org.sonar.plugins.javascript.api.symbols.Type;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.declaration.ParameterListTree;
import org.sonar.plugins.javascript.api.tree.expression.CallExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.DotMemberExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.ExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.IdentifierTree;
import org.sonar.plugins.javascript.api.tree.expression.MemberExpressionTree;
import org.sonar.plugins.javascript.api.tree.statement.ExpressionStatementTree;
import org.sonar.plugins.javascript.api.visitors.SubscriptionVisitorCheck;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;

@Rule(key="S1154", name="Results of operations on strings should not be ignored", priority=Priority.BLOCKER, tags={"bug"})
@ActivatedByDefault
@SqaleConstantRemediation(value="20min")
public class UselessStringOperationCheck
extends SubscriptionVisitorCheck {
    private static final String MESSAGE = "%s is an immutable object; you must either store or return the result of the operation.";

    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.EXPRESSION_STATEMENT);
    }

    public void visitNode(Tree tree) {
        DotMemberExpressionTree memberExpression;
        ExpressionTree callee;
        Tree expression = ((ExpressionStatementTree)tree).expression();
        if (expression.is(new Tree.Kind[]{Tree.Kind.CALL_EXPRESSION}) && (callee = ((CallExpressionTree)expression).callee()).is(new Tree.Kind[]{Tree.Kind.DOT_MEMBER_EXPRESSION}) && (memberExpression = (DotMemberExpressionTree)callee).object().types().containsOnly(Type.Kind.STRING) && !UselessStringOperationCheck.isReplaceExclusion(memberExpression.property(), ((CallExpressionTree)expression).arguments())) {
            this.addIssue((Tree)memberExpression.property(), String.format(MESSAGE, UselessStringOperationCheck.getVariable((MemberExpressionTree)memberExpression)));
        }
    }

    private static boolean isReplaceExclusion(IdentifierTree property, ParameterListTree arguments) {
        if ("replace".equals(property.name()) && arguments.parameters().size() == 2) {
            Tree secondArgument = (Tree)arguments.parameters().get(1);
            return secondArgument instanceof ExpressionTree && !((ExpressionTree)secondArgument).types().containsOnly(Type.Kind.STRING);
        }
        return false;
    }

    private static String getVariable(MemberExpressionTree memberExpression) {
        String variableName = CheckUtils.asString((Tree)memberExpression.object());
        if (variableName.length() > 30) {
            variableName = "String";
        }
        return variableName;
    }
}

