/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.statement.VariableDeclarationTree;
import org.sonar.plugins.javascript.api.visitors.SubscriptionVisitorCheck;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;

@Rule(key="S3504", name="Variables should be declared with \"let\" or \"const\"", priority=Priority.MAJOR, tags={"bad-practice", "es2015"})
@SqaleConstantRemediation(value="5min")
public class VarDeclarationCheck
extends SubscriptionVisitorCheck {
    private static final String MESSAGE = "Replace \"var\" with \"let\" or \"const\"";

    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.VAR_DECLARATION);
    }

    public void visitNode(Tree tree) {
        this.addIssue((Tree)((VariableDeclarationTree)tree).token(), MESSAGE);
    }
}

