/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import java.util.HashMap;
import java.util.Map;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.javascript.se.Constraint;
import org.sonar.javascript.se.ProgramState;
import org.sonar.javascript.se.SeCheck;
import org.sonar.javascript.se.sv.SymbolicValue;
import org.sonar.javascript.tree.symbols.Scope;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.expression.CallExpressionTree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;

@Rule(key="S2873", name="Calls should not be made to non-callable values", priority=Priority.BLOCKER, tags={"bug"})
@SqaleConstantRemediation(value="5min")
@ActivatedByDefault
public class CallabilityCheck
extends SeCheck {
    private static final String MESSAGE = "This expression has a value which cannot be called; it is not a function.";
    private Map<CallExpressionTree, Boolean> callability = new HashMap<CallExpressionTree, Boolean>();

    public void endOfExecution(Scope functionScope) {
        for (Map.Entry<CallExpressionTree, Boolean> entry : this.callability.entrySet()) {
            if (entry.getValue().booleanValue()) continue;
            this.addIssue((Tree)entry.getKey().callee(), MESSAGE);
        }
    }

    public void startOfExecution(Scope functionScope) {
        this.callability.clear();
    }

    public void beforeBlockElement(ProgramState currentState, Tree element) {
        if (element.is(new Tree.Kind[]{Tree.Kind.CALL_EXPRESSION})) {
            boolean isCallable;
            CallExpressionTree callExpression = (CallExpressionTree)element;
            SymbolicValue calleeSV = currentState.peekStack(callExpression.arguments().parameters().size());
            Constraint constraint = currentState.getConstraint(calleeSV);
            boolean bl = isCallable = !constraint.isIncompatibleWith(Constraint.FUNCTION);
            if (isCallable) {
                this.callability.put(callExpression, true);
            } else if (!this.callability.containsKey(callExpression)) {
                this.callability.put(callExpression, false);
            }
        }
    }
}

