/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.javascript.checks.EscapeUtils;
import org.sonar.javascript.tree.impl.declaration.ParameterListTreeImpl;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.declaration.ParameterListTree;
import org.sonar.plugins.javascript.api.tree.expression.IdentifierTree;
import org.sonar.plugins.javascript.api.visitors.DoubleDispatchVisitorCheck;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;

@Rule(key="DuplicateFunctionArgument", name="Function argument names should be unique", priority=Priority.CRITICAL, tags={"pitfall"})
@ActivatedByDefault
@SqaleConstantRemediation(value="5min")
public class DuplicateFunctionArgumentCheck
extends DoubleDispatchVisitorCheck {
    private static final String MESSAGE = "Rename the duplicated function parameter \"%s\".";

    public void visitParameterList(ParameterListTree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.FORMAL_PARAMETER_LIST})) {
            HashMap duplicatedParameters = new HashMap();
            for (IdentifierTree identifier : ((ParameterListTreeImpl)tree).parameterIdentifiers()) {
                String value = identifier.name();
                String unescaped = EscapeUtils.unescape(value);
                if (!duplicatedParameters.containsKey(unescaped)) {
                    duplicatedParameters.put(unescaped, new ArrayList());
                }
                ((List)duplicatedParameters.get(unescaped)).add(identifier);
            }
            for (List sameNameParameters : duplicatedParameters.values()) {
                if (sameNameParameters.size() <= 1) continue;
                for (IdentifierTree duplicatingParameter : sameNameParameters.subList(1, sameNameParameters.size())) {
                    String message = String.format(MESSAGE, duplicatingParameter.name());
                    this.addIssue((Tree)duplicatingParameter, message).secondary((Tree)sameNameParameters.get(0));
                }
            }
        }
        super.visitParameterList(tree);
    }
}

