/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.javascript.checks.utils.CheckUtils;
import org.sonar.plugins.javascript.api.tree.ScriptTree;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.declaration.FunctionDeclarationTree;
import org.sonar.plugins.javascript.api.tree.declaration.MethodDeclarationTree;
import org.sonar.plugins.javascript.api.tree.expression.IdentifierTree;
import org.sonar.plugins.javascript.api.visitors.DoubleDispatchVisitorCheck;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;

@Rule(key="S100", name="Function names should comply with a naming convention", priority=Priority.MINOR, tags={"convention"})
@SqaleConstantRemediation(value="5min")
public class FunctionNameCheck
extends DoubleDispatchVisitorCheck {
    public static final String DEFAULT = "^[a-z][a-zA-Z0-9]*$";
    private static final String MESSAGE = "Rename this '%s' function to match the regular expression %s";
    private Pattern pattern = null;
    @RuleProperty(key="format", description="Regular expression used to check the function names against.", defaultValue="^[a-z][a-zA-Z0-9]*$")
    public String format = "^[a-z][a-zA-Z0-9]*$";

    public void visitScript(ScriptTree tree) {
        this.pattern = Pattern.compile(this.format);
        super.visitScript(tree);
    }

    public void visitMethodDeclaration(MethodDeclarationTree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.GENERATOR_METHOD, Tree.Kind.METHOD})) {
            this.checkName(tree.name());
        }
        super.visitMethodDeclaration(tree);
    }

    public void visitFunctionDeclaration(FunctionDeclarationTree tree) {
        this.checkName((Tree)tree.name());
        super.visitFunctionDeclaration(tree);
    }

    private void checkName(@Nullable Tree tree) {
        if (tree != null) {
            String name;
            String string = name = tree.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER_NAME}) ? ((IdentifierTree)tree).name() : CheckUtils.asString(tree);
            if (!this.pattern.matcher(name).matches()) {
                this.addIssue(tree, String.format(MESSAGE, name, this.format));
            }
        }
    }
}

