/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.expression.IdentifierTree;
import org.sonar.plugins.javascript.api.tree.expression.PairPropertyTree;
import org.sonar.plugins.javascript.api.visitors.DoubleDispatchVisitorCheck;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;

@Rule(key="S3498", name="Object literal shorthand syntax should be used", priority=Priority.MINOR, tags={"convention", "es2015"})
@SqaleConstantRemediation(value="1min")
public class ObjectLiteralShorthandCheck
extends DoubleDispatchVisitorCheck {
    private static final String MESSAGE = "Use shorthand for %s \"%s\".";

    public void visitPairProperty(PairPropertyTree tree) {
        if (tree.key().is(new Tree.Kind[]{Tree.Kind.IDENTIFIER_NAME})) {
            String keyName = ((IdentifierTree)tree.key()).name();
            if (tree.value().is(new Tree.Kind[]{Tree.Kind.IDENTIFIER_REFERENCE}) && ((IdentifierTree)tree.value()).name().equals(keyName)) {
                this.raiseIssue("property", keyName, tree.key());
            }
            if (tree.value().is(new Tree.Kind[]{Tree.Kind.FUNCTION_EXPRESSION})) {
                this.raiseIssue("method", keyName, tree.key());
            }
        }
        super.visitPairProperty(tree);
    }

    private void raiseIssue(String kind, String keyName, Tree highlighted) {
        String message = String.format(MESSAGE, kind, keyName);
        this.addIssue(highlighted, message);
    }
}

