/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import javax.annotation.Nullable;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.javascript.checks.utils.CheckUtils;
import org.sonar.javascript.tree.impl.JavaScriptTree;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.expression.BinaryExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.ExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.NewExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.ParenthesisedExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.UnaryExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.YieldExpressionTree;
import org.sonar.plugins.javascript.api.tree.statement.ForObjectStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.ReturnStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.ThrowStatementTree;
import org.sonar.plugins.javascript.api.visitors.DoubleDispatchVisitorCheck;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;

@Rule(key="Parentheses", name="Useless parentheses around expressions should be removed to prevent any misunderstanding", priority=Priority.MAJOR, tags={"confusing"})
@SqaleConstantRemediation(value="1min")
public class ParenthesesCheck
extends DoubleDispatchVisitorCheck {
    private static final String MESSAGE = "Remove useless parentheses around \"%s\".";
    private static final Tree.Kind[] SHOULD_BE_PARENTHESISED_AFTER_TYPEOF = new Tree.Kind[]{Tree.Kind.CONDITIONAL_EXPRESSION, Tree.Kind.MULTIPLY, Tree.Kind.DIVIDE, Tree.Kind.REMAINDER, Tree.Kind.PLUS, Tree.Kind.MINUS, Tree.Kind.LEFT_SHIFT, Tree.Kind.RIGHT_SHIFT, Tree.Kind.UNSIGNED_RIGHT_SHIFT, Tree.Kind.LESS_THAN, Tree.Kind.GREATER_THAN, Tree.Kind.LESS_THAN_OR_EQUAL_TO, Tree.Kind.GREATER_THAN_OR_EQUAL_TO, Tree.Kind.EQUAL_TO, Tree.Kind.STRICT_EQUAL_TO, Tree.Kind.NOT_EQUAL_TO, Tree.Kind.STRICT_NOT_EQUAL_TO, Tree.Kind.BITWISE_AND, Tree.Kind.BITWISE_OR, Tree.Kind.BITWISE_XOR, Tree.Kind.CONDITIONAL_AND, Tree.Kind.CONDITIONAL_OR, Tree.Kind.ASSIGNMENT, Tree.Kind.MULTIPLY_ASSIGNMENT, Tree.Kind.EXPONENT_ASSIGNMENT, Tree.Kind.DIVIDE_ASSIGNMENT, Tree.Kind.REMAINDER_ASSIGNMENT, Tree.Kind.PLUS_ASSIGNMENT, Tree.Kind.MINUS_ASSIGNMENT, Tree.Kind.LEFT_SHIFT_ASSIGNMENT, Tree.Kind.RIGHT_SHIFT_ASSIGNMENT, Tree.Kind.UNSIGNED_RIGHT_SHIFT_ASSIGNMENT, Tree.Kind.AND_ASSIGNMENT, Tree.Kind.XOR_ASSIGNMENT, Tree.Kind.OR_ASSIGNMENT};

    public void visitUnaryExpression(UnaryExpressionTree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.DELETE, Tree.Kind.VOID})) {
            this.checkExpression(tree.expression());
        }
        if (tree.is(new Tree.Kind[]{Tree.Kind.TYPEOF})) {
            this.checkTypeOfExpression(tree.expression());
        }
        super.visitUnaryExpression(tree);
    }

    public void visitReturnStatement(ReturnStatementTree tree) {
        this.checkExpression(tree.expression(), true);
        super.visitReturnStatement(tree);
    }

    public void visitThrowStatement(ThrowStatementTree tree) {
        this.checkExpression(tree.expression(), true);
        super.visitThrowStatement(tree);
    }

    public void visitYieldExpression(YieldExpressionTree tree) {
        this.checkExpression(tree.argument(), true);
        super.visitYieldExpression(tree);
    }

    public void visitNewExpression(NewExpressionTree tree) {
        ParenthesisedExpressionTree parenthesisedExpression;
        if (tree.arguments() == null && tree.expression().is(new Tree.Kind[]{Tree.Kind.PARENTHESISED_EXPRESSION}) && !((parenthesisedExpression = (ParenthesisedExpressionTree)tree.expression()).expression() instanceof BinaryExpressionTree)) {
            this.checkExpression(tree.expression());
        }
        super.visitNewExpression(tree);
    }

    public void visitForObjectStatement(ForObjectStatementTree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.FOR_IN_STATEMENT})) {
            this.checkExpression(tree.expression());
        }
        super.visitForObjectStatement(tree);
    }

    private void checkExpression(@Nullable ExpressionTree expression) {
        this.checkExpression(expression, false);
    }

    private void checkExpression(@Nullable ExpressionTree expression, boolean checkNewLineException) {
        if (expression != null && expression.is(new Tree.Kind[]{Tree.Kind.PARENTHESISED_EXPRESSION})) {
            int bodyLine;
            int openParenthesisLine;
            ParenthesisedExpressionTree parenthesisedExpression = (ParenthesisedExpressionTree)expression;
            if (checkNewLineException && (openParenthesisLine = parenthesisedExpression.openParenthesis().line()) < (bodyLine = ((JavaScriptTree)parenthesisedExpression.expression()).getLine())) {
                return;
            }
            String expressingString = CheckUtils.asString((Tree)parenthesisedExpression.expression());
            this.addIssue((Tree)expression, String.format(MESSAGE, expressingString));
        }
    }

    private void checkTypeOfExpression(ExpressionTree expression) {
        ExpressionTree nestedExpr;
        if (expression.is(new Tree.Kind[]{Tree.Kind.PARENTHESISED_EXPRESSION}) && (nestedExpr = ((ParenthesisedExpressionTree)expression).expression()) != null && !nestedExpr.is(SHOULD_BE_PARENTHESISED_AFTER_TYPEOF)) {
            String expressingString = CheckUtils.asString((Tree)nestedExpr);
            this.addIssue((Tree)expression, String.format(MESSAGE, expressingString));
        }
    }
}

