/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.javascript.tree.SyntacticEquivalence;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.expression.AssignmentExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.ExpressionTree;
import org.sonar.plugins.javascript.api.visitors.DoubleDispatchVisitorCheck;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;

@Rule(key="S1656", name="Variables should not be self-assigned", priority=Priority.MAJOR, tags={"bug", "cert"})
@ActivatedByDefault
@SqaleConstantRemediation(value="3min")
public class SelfAssignmentCheck
extends DoubleDispatchVisitorCheck {
    private static final String MESSAGE = "Remove or correct this useless self-assignment.";

    public void visitAssignmentExpression(AssignmentExpressionTree tree) {
        ExpressionTree variable = tree.variable();
        if (tree.is(new Tree.Kind[]{Tree.Kind.ASSIGNMENT}) && SyntacticEquivalence.areEquivalent((Tree)variable, (Tree)tree.expression())) {
            this.addIssue((Tree)tree, MESSAGE);
        }
        super.visitAssignmentExpression(tree);
    }
}

