/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import javax.annotation.Nullable;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.declaration.DefaultExportDeclarationTree;
import org.sonar.plugins.javascript.api.tree.declaration.ExportClauseTree;
import org.sonar.plugins.javascript.api.tree.declaration.ImportDeclarationTree;
import org.sonar.plugins.javascript.api.tree.declaration.ImportModuleDeclarationTree;
import org.sonar.plugins.javascript.api.tree.declaration.NameSpaceExportDeclarationTree;
import org.sonar.plugins.javascript.api.tree.lexical.SyntaxToken;
import org.sonar.plugins.javascript.api.tree.statement.BreakStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.ContinueStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.DebuggerStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.DoWhileStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.ExpressionStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.ReturnStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.ThrowStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.VariableStatementTree;
import org.sonar.plugins.javascript.api.visitors.DoubleDispatchVisitorCheck;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;

@Rule(key="Semicolon", name="Each statement should end with a semicolon", priority=Priority.MINOR, tags={"convention"})
@SqaleConstantRemediation(value="1min")
public class SemicolonCheck
extends DoubleDispatchVisitorCheck {
    private static final String MESSAGE = "Add a semicolon at the end of this statement.";

    private void checkEOS(Tree tree, @Nullable SyntaxToken semicolonToken) {
        if (semicolonToken == null) {
            this.addIssue(tree, MESSAGE);
        }
    }

    public void visitDefaultExportDeclaration(DefaultExportDeclarationTree tree) {
        super.visitDefaultExportDeclaration(tree);
        boolean exportedObjectIsClassOrFunctionDeclaration = tree.object().is(new Tree.Kind[]{Tree.Kind.FUNCTION_DECLARATION, Tree.Kind.FUNCTION_EXPRESSION, Tree.Kind.CLASS_DECLARATION, Tree.Kind.CLASS_EXPRESSION, Tree.Kind.GENERATOR_DECLARATION, Tree.Kind.GENERATOR_FUNCTION_EXPRESSION});
        if (!exportedObjectIsClassOrFunctionDeclaration) {
            this.checkEOS((Tree)tree, tree.semicolonToken());
        }
    }

    public void visitNameSpaceExportDeclaration(NameSpaceExportDeclarationTree tree) {
        super.visitNameSpaceExportDeclaration(tree);
        this.checkEOS((Tree)tree, tree.semicolonToken());
    }

    public void visitExportClause(ExportClauseTree tree) {
        super.visitExportClause(tree);
        this.checkEOS((Tree)tree, tree.semicolonToken());
    }

    public void visitImportDeclaration(ImportDeclarationTree tree) {
        super.visitImportDeclaration(tree);
        this.checkEOS((Tree)tree, tree.semicolonToken());
    }

    public void visitImportModuleDeclaration(ImportModuleDeclarationTree tree) {
        super.visitImportModuleDeclaration(tree);
        this.checkEOS((Tree)tree, tree.semicolonToken());
    }

    public void visitVariableStatement(VariableStatementTree tree) {
        super.visitVariableStatement(tree);
        this.checkEOS((Tree)tree, tree.semicolonToken());
    }

    public void visitExpressionStatement(ExpressionStatementTree tree) {
        super.visitExpressionStatement(tree);
        this.checkEOS((Tree)tree, tree.semicolonToken());
    }

    public void visitDoWhileStatement(DoWhileStatementTree tree) {
        super.visitDoWhileStatement(tree);
        this.checkEOS((Tree)tree, tree.semicolonToken());
    }

    public void visitContinueStatement(ContinueStatementTree tree) {
        super.visitContinueStatement(tree);
        this.checkEOS((Tree)tree, tree.semicolonToken());
    }

    public void visitBreakStatement(BreakStatementTree tree) {
        super.visitBreakStatement(tree);
        this.checkEOS((Tree)tree, tree.semicolonToken());
    }

    public void visitReturnStatement(ReturnStatementTree tree) {
        super.visitReturnStatement(tree);
        this.checkEOS((Tree)tree, tree.semicolonToken());
    }

    public void visitThrowStatement(ThrowStatementTree tree) {
        super.visitThrowStatement(tree);
        this.checkEOS((Tree)tree, tree.semicolonToken());
    }

    public void visitDebugger(DebuggerStatementTree tree) {
        super.visitDebugger(tree);
        this.checkEOS((Tree)tree, tree.semicolonToken());
    }
}

