/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.CheckForNull;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.javascript.se.Constraint;
import org.sonar.javascript.se.ProgramState;
import org.sonar.javascript.se.SeCheck;
import org.sonar.javascript.se.Type;
import org.sonar.javascript.tree.symbols.Scope;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.expression.BinaryExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.ExpressionTree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;

@Rule(key="S3402", name="Strings and non-strings should not be added", priority=Priority.MAJOR, tags={"suspicious"})
@ActivatedByDefault
@SqaleConstantRemediation(value="15min")
public class StringConcatenatedWithNonStringCheck
extends SeCheck {
    private static final String MESSAGE = "Either make this concatenation explicit or cast one operand to a number.";
    private Map<BinaryExpressionTree, Boolean> appropriateTypes = new HashMap<BinaryExpressionTree, Boolean>();

    public void beforeBlockElement(ProgramState currentState, Tree element) {
        if (element.is(new Tree.Kind[]{Tree.Kind.PLUS})) {
            BinaryExpressionTree expression = (BinaryExpressionTree)element;
            ExpressionTree onlyStringOperand = StringConcatenatedWithNonStringCheck.getOnlyStringOperand(expression.leftOperand(), expression.rightOperand(), currentState);
            if (onlyStringOperand == null || !onlyStringOperand.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER_REFERENCE})) {
                this.appropriateTypes.put(expression, false);
            } else if (!this.appropriateTypes.containsKey(expression)) {
                this.appropriateTypes.put(expression, true);
            }
        }
    }

    public void endOfExecution(Scope functionScope) {
        for (Map.Entry<BinaryExpressionTree, Boolean> entry : this.appropriateTypes.entrySet()) {
            if (!entry.getValue().booleanValue()) continue;
            BinaryExpressionTree tree = entry.getKey();
            this.addIssue((Tree)tree.operator(), MESSAGE).secondary((Tree)tree.leftOperand()).secondary((Tree)tree.rightOperand());
        }
    }

    public void startOfExecution(Scope functionScope) {
        this.appropriateTypes.clear();
    }

    @CheckForNull
    private static ExpressionTree getOnlyStringOperand(ExpressionTree leftOperand, ExpressionTree rightOperand, ProgramState currentState) {
        Constraint rightConstraint = currentState.getConstraint(currentState.peekStack(0));
        Constraint leftConstraint = currentState.getConstraint(currentState.peekStack(1));
        Type rightType = rightConstraint.type();
        Type leftType = leftConstraint.type();
        if (leftType != null && rightType != null) {
            if (leftType == Type.STRING && rightType != Type.STRING) {
                return leftOperand;
            }
            if (leftType != Type.STRING && rightType == Type.STRING) {
                return rightOperand;
            }
        }
        return null;
    }
}

