/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import java.util.HashMap;
import java.util.Map;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.javascript.se.Constraint;
import org.sonar.javascript.se.ProgramState;
import org.sonar.javascript.se.SeCheck;
import org.sonar.javascript.se.Type;
import org.sonar.javascript.tree.symbols.Scope;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.expression.BinaryExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.LiteralTree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;

@Rule(key="S3003", name="Comparison operators should not be used with strings", priority=Priority.MAJOR, tags={"suspicious"})
@ActivatedByDefault
@SqaleConstantRemediation(value="5min")
public class StringsComparisonCheck
extends SeCheck {
    private static final String MESSAGE = "Convert operands of this use of \"%s\" to number type.";
    private static final Tree.Kind[] RELATIVE_OPERATIONS = new Tree.Kind[]{Tree.Kind.LESS_THAN, Tree.Kind.LESS_THAN_OR_EQUAL_TO, Tree.Kind.GREATER_THAN, Tree.Kind.GREATER_THAN_OR_EQUAL_TO};
    private Map<BinaryExpressionTree, Boolean> stringsComparisons = new HashMap<BinaryExpressionTree, Boolean>();

    public void beforeBlockElement(ProgramState currentState, Tree element) {
        if (element.is(RELATIVE_OPERATIONS)) {
            boolean stringsCompared;
            BinaryExpressionTree comparison = (BinaryExpressionTree)element;
            Constraint rightConstraint = currentState.getConstraint(currentState.peekStack(0));
            Constraint leftConstraint = currentState.getConstraint(currentState.peekStack(1));
            Type rightType = rightConstraint.type();
            Type leftType = leftConstraint.type();
            boolean bl = stringsCompared = rightType == Type.STRING && leftType == Type.STRING;
            if (!stringsCompared) {
                this.stringsComparisons.put(comparison, false);
            } else if (!this.stringsComparisons.containsKey(comparison)) {
                this.stringsComparisons.put(comparison, true);
            }
        }
    }

    public void startOfExecution(Scope functionScope) {
        this.stringsComparisons.clear();
    }

    public void endOfExecution(Scope functionScope) {
        for (Map.Entry<BinaryExpressionTree, Boolean> entry : this.stringsComparisons.entrySet()) {
            if (!entry.getValue().booleanValue() || StringsComparisonCheck.hasOneSymbolLiteralOperand(entry.getKey())) continue;
            this.raiseIssue(entry.getKey());
        }
    }

    private static boolean hasOneSymbolLiteralOperand(BinaryExpressionTree expression) {
        LiteralTree literal = null;
        if (expression.leftOperand().is(new Tree.Kind[]{Tree.Kind.STRING_LITERAL})) {
            literal = (LiteralTree)expression.leftOperand();
        } else if (expression.rightOperand().is(new Tree.Kind[]{Tree.Kind.STRING_LITERAL})) {
            literal = (LiteralTree)expression.rightOperand();
        }
        return literal != null && literal.value().length() == 3;
    }

    private void raiseIssue(BinaryExpressionTree tree) {
        String message = String.format(MESSAGE, tree.operator().text());
        this.addIssue((Tree)tree.operator(), message).secondary((Tree)tree.leftOperand()).secondary((Tree)tree.rightOperand());
    }
}

