/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.javascript.checks.utils.CheckUtils;
import org.sonar.javascript.se.Constraint;
import org.sonar.javascript.se.ProgramState;
import org.sonar.javascript.se.SeCheck;
import org.sonar.javascript.se.Type;
import org.sonar.javascript.tree.symbols.Scope;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.expression.UnaryExpressionTree;
import org.sonar.plugins.javascript.api.tree.lexical.SyntaxToken;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;

@Rule(key="S3002", name="Unary operators \"+\" and \"-\" should not be used with objects", priority=Priority.CRITICAL, tags={"bug"})
@SqaleConstantRemediation(value="15min")
@ActivatedByDefault
public class UnaryPlusMinusWithObjectCheck
extends SeCheck {
    private static final String MESSAGE = "Remove this use of unary \"%s\".";
    private static final EnumSet<Type> NOT_ALLOWED_TYPES = EnumSet.of(Type.OTHER_OBJECT, Type.ARRAY, Type.FUNCTION, Type.OBJECT);
    private Map<UnaryExpressionTree, Boolean> objectTypes = new HashMap<UnaryExpressionTree, Boolean>();

    public void beforeBlockElement(ProgramState currentState, Tree element) {
        if (element.is(new Tree.Kind[]{Tree.Kind.UNARY_MINUS, Tree.Kind.UNARY_PLUS})) {
            boolean objectType;
            UnaryExpressionTree unaryExpression = (UnaryExpressionTree)element;
            Constraint constraint = currentState.getConstraint(currentState.peekStack());
            Type type = constraint.type();
            boolean bl = objectType = type != null && NOT_ALLOWED_TYPES.contains(type);
            if (!objectType) {
                this.objectTypes.put(unaryExpression, false);
            } else if (!this.objectTypes.containsKey(unaryExpression)) {
                this.objectTypes.put(unaryExpression, true);
            }
        }
    }

    public void endOfExecution(Scope functionScope) {
        for (Map.Entry<UnaryExpressionTree, Boolean> entry : this.objectTypes.entrySet()) {
            if (!entry.getValue().booleanValue() || UnaryPlusMinusWithObjectCheck.isDateException((Tree)entry.getKey())) continue;
            SyntaxToken operator = entry.getKey().operator();
            this.addIssue((Tree)operator, String.format(MESSAGE, operator.text()));
        }
    }

    public void startOfExecution(Scope functionScope) {
        this.objectTypes.clear();
    }

    private static boolean isDateException(Tree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.UNARY_PLUS})) {
            String exprString = CheckUtils.asString((Tree)((UnaryExpressionTree)tree).expression());
            return exprString.contains("Date") || exprString.contains("date");
        }
        return false;
    }
}

