/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.javascript.tree.SyntacticEquivalence;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.expression.AssignmentExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.UnaryExpressionTree;
import org.sonar.plugins.javascript.api.visitors.DoubleDispatchVisitorCheck;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;

@Rule(key="S2123", name="Values should not be uselessly incremented", priority=Priority.CRITICAL, tags={"bug"})
@ActivatedByDefault
@SqaleConstantRemediation(value="5min")
public class UselessIncrementCheck
extends DoubleDispatchVisitorCheck {
    private static final String MESSAGE = "Remove this %s or correct the code not to waste it.";

    public void visitAssignmentExpression(AssignmentExpressionTree assignment) {
        if (assignment.expression().is(new Tree.Kind[]{Tree.Kind.POSTFIX_INCREMENT, Tree.Kind.POSTFIX_DECREMENT})) {
            UnaryExpressionTree postfix = (UnaryExpressionTree)assignment.expression();
            if (SyntacticEquivalence.areEquivalent((Tree)assignment.variable(), (Tree)postfix.expression())) {
                String type = postfix.is(new Tree.Kind[]{Tree.Kind.POSTFIX_INCREMENT}) ? "increment" : "decrement";
                String message = String.format(MESSAGE, type);
                this.addIssue((Tree)postfix.operator(), message);
            }
        }
        super.visitAssignmentExpression(assignment);
    }
}

