/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.declaration.NameSpaceExportDeclarationTree;
import org.sonar.plugins.javascript.api.tree.declaration.SpecifierTree;
import org.sonar.plugins.javascript.api.visitors.DoubleDispatchVisitorCheck;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;

@Rule(key="S2208", name="Wildcard imports should not be used", priority=Priority.MAJOR, tags={"es2015", "pitfall"})
@SqaleConstantRemediation(value="5min")
public class WildcardImportCheck
extends DoubleDispatchVisitorCheck {
    private static final String MESSAGE = "Explicitly import the specific member needed.";

    public void visitNameSpaceExportDeclaration(NameSpaceExportDeclarationTree tree) {
        this.addIssue((Tree)tree.starToken(), MESSAGE);
        super.visitNameSpaceExportDeclaration(tree);
    }

    public void visitSpecifier(SpecifierTree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.NAMESPACE_IMPORT_SPECIFIER})) {
            this.addIssue(tree.name(), MESSAGE);
        }
        super.visitSpecifier(tree);
    }
}

