/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import org.sonar.check.Rule;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.expression.CallExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.ExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.IdentifierTree;
import org.sonar.plugins.javascript.api.visitors.DoubleDispatchVisitorCheck;

@Rule(key="S1442")
public class AlertUseCheck
extends DoubleDispatchVisitorCheck {
    private static final String MESSAGE = "Remove this usage of alert(...).";

    public void visitCallExpression(CallExpressionTree tree) {
        ExpressionTree callee = tree.callee();
        if (callee.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER_REFERENCE}) && AlertUseCheck.isAlertCall((IdentifierTree)callee)) {
            this.addIssue((Tree)tree, MESSAGE);
        }
        super.visitCallExpression(tree);
    }

    public static boolean isAlertCall(IdentifierTree identifier) {
        return "alert".equals(identifier.name());
    }
}

