/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.javascript.se.SeCheck;
import org.sonar.javascript.se.Truthiness;
import org.sonar.javascript.tree.symbols.Scope;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.expression.ExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.LiteralTree;
import org.sonar.plugins.javascript.api.tree.statement.DoWhileStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.ForStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.WhileStatementTree;
import org.sonar.plugins.javascript.api.visitors.DoubleDispatchVisitor;

@Rule(key="S2583")
public class AlwaysTrueOrFalseConditionCheck
extends SeCheck {
    private Set<LiteralTree> ignoredLoopConditions;

    public void startOfExecution(Scope functionScope) {
        this.ignoredLoopConditions = new HashSet<LiteralTree>();
        Tree tree = functionScope.tree();
        tree.accept((DoubleDispatchVisitor)new LoopsVisitor());
    }

    public void checkConditions(Map<Tree, Collection<Truthiness>> conditions) {
        for (Map.Entry<Tree, Collection<Truthiness>> entry : conditions.entrySet()) {
            Collection<Truthiness> results;
            if (this.ignoredLoopConditions.contains(entry.getKey()) || (results = entry.getValue()).size() != 1 || Truthiness.UNKNOWN.equals((Object)results.iterator().next())) continue;
            String result = Truthiness.TRUTHY.equals((Object)results.iterator().next()) ? "true" : "false";
            this.addIssue(entry.getKey(), String.format("Change this condition so that it does not always evaluate to \"%s\".", result));
        }
    }

    private class LoopsVisitor
    extends DoubleDispatchVisitor {
        private LoopsVisitor() {
        }

        public void visitForStatement(ForStatementTree tree) {
            this.checkCondition(tree.condition());
            super.visitForStatement(tree);
        }

        public void visitWhileStatement(WhileStatementTree tree) {
            this.checkCondition(tree.condition());
            super.visitWhileStatement(tree);
        }

        public void visitDoWhileStatement(DoWhileStatementTree tree) {
            this.checkCondition(tree.condition());
            super.visitDoWhileStatement(tree);
        }

        private void checkCondition(@Nullable ExpressionTree condition) {
            if (condition != null && condition.is(new Tree.Kind[]{Tree.Kind.BOOLEAN_LITERAL, Tree.Kind.NUMERIC_LITERAL})) {
                AlwaysTrueOrFalseConditionCheck.this.ignoredLoopConditions.add((LiteralTree)condition);
            }
        }
    }
}

