/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import org.sonar.check.Rule;
import org.sonar.javascript.checks.AbstractAllPathSeCheck;
import org.sonar.javascript.se.Constraint;
import org.sonar.javascript.se.ProgramState;
import org.sonar.javascript.se.sv.SymbolicValue;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.expression.CallExpressionTree;

@Rule(key="S2873")
public class CallabilityCheck
extends AbstractAllPathSeCheck<CallExpressionTree> {
    private static final String MESSAGE = "This expression has a value which cannot be called; it is not a function.";

    @Override
    void raiseIssue(CallExpressionTree tree) {
        this.addIssue((Tree)tree.callee(), MESSAGE);
    }

    @Override
    boolean isProblem(CallExpressionTree tree, ProgramState currentState) {
        SymbolicValue calleeSV = currentState.peekStack(tree.arguments().parameters().size());
        Constraint constraint = currentState.getConstraint(calleeSV);
        return constraint.isIncompatibleWith(Constraint.FUNCTION);
    }

    @Override
    CallExpressionTree getTree(Tree element) {
        if (element.is(new Tree.Kind[]{Tree.Kind.CALL_EXPRESSION})) {
            return (CallExpressionTree)element;
        }
        return null;
    }
}

