/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import org.sonar.check.Rule;
import org.sonar.javascript.checks.utils.CheckUtils;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.expression.NewExpressionTree;
import org.sonar.plugins.javascript.api.tree.statement.ExpressionStatementTree;
import org.sonar.plugins.javascript.api.visitors.DoubleDispatchVisitorCheck;

@Rule(key="ConstructorFunctionsForSideEffects")
public class ConstructorFunctionsForSideEffectsCheck
extends DoubleDispatchVisitorCheck {
    private static final String MESSAGE = "Either remove this useless object instantiation of \"%s\" or use it";

    public void visitExpressionStatement(ExpressionStatementTree tree) {
        Tree expression = tree.expression();
        if (expression.is(new Tree.Kind[]{Tree.Kind.NEW_EXPRESSION})) {
            String message = String.format(MESSAGE, CheckUtils.asString((Tree)((NewExpressionTree)expression).expression()));
            this.addIssue(expression, message);
        }
        super.visitExpressionStatement(tree);
    }
}

