/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.javascript.tree.visitors.CharsetAwareVisitor;
import org.sonar.plugins.javascript.api.JavaScriptCheck;
import org.sonar.plugins.javascript.api.tree.ScriptTree;
import org.sonar.plugins.javascript.api.visitors.DoubleDispatchVisitorCheck;
import org.sonar.plugins.javascript.api.visitors.FileIssue;
import org.sonar.plugins.javascript.api.visitors.Issue;

@Rule(key="S1451")
public class FileHeaderCheck
extends DoubleDispatchVisitorCheck
implements CharsetAwareVisitor {
    private static final String MESSAGE = "Add or update the header of this file.";
    private static final String DEFAULT_HEADER_FORMAT = "";
    @RuleProperty(key="headerFormat", description="Expected copyright and license header", defaultValue="", type="TEXT")
    public String headerFormat = "";
    @RuleProperty(key="isRegularExpression", description="Whether the headerFormat is a regular expression", defaultValue="false")
    public boolean isRegularExpression = false;
    private Charset charset;
    private String[] expectedLines = null;
    private Pattern searchPattern = null;

    public void setCharset(Charset charset) {
        this.charset = charset;
    }

    public void visitScript(ScriptTree tree) {
        if (this.isRegularExpression) {
            this.checkRegularExpression();
        } else {
            this.checkPlainText();
        }
    }

    private void checkPlainText() {
        List lines;
        if (this.expectedLines == null) {
            this.expectedLines = this.headerFormat.split("(?:\r)?\n|\r");
        }
        try {
            lines = Files.readLines((File)this.getContext().getFile(), (Charset)this.charset);
        }
        catch (IOException e) {
            String fileName = this.getContext().getFile().getName();
            throw new IllegalStateException("Unable to execute rule \"S1451\" for file " + fileName, e);
        }
        if (!FileHeaderCheck.matches(this.expectedLines, lines)) {
            this.addIssue((Issue)new FileIssue((JavaScriptCheck)this, MESSAGE));
        }
    }

    private void checkRegularExpression() {
        String fileContent;
        if (this.searchPattern == null) {
            try {
                this.searchPattern = Pattern.compile(this.headerFormat, 32);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("[" + ((Object)((Object)this)).getClass().getSimpleName() + "] Unable to compile the regular expression: " + this.headerFormat, e);
            }
        }
        try {
            fileContent = Files.toString((File)this.getContext().getFile(), (Charset)this.charset);
        }
        catch (IOException e) {
            String fileName = this.getContext().getFile().getName();
            throw new IllegalStateException("Unable to execute rule \"S1451\" for file " + fileName, e);
        }
        Matcher matcher = this.searchPattern.matcher(fileContent);
        if (!matcher.find() || matcher.start() != 0) {
            this.addIssue((Issue)new FileIssue((JavaScriptCheck)this, MESSAGE));
        }
    }

    private static boolean matches(String[] expectedLines, List<String> lines) {
        boolean result;
        if (expectedLines.length <= lines.size()) {
            result = true;
            Iterator<String> it = lines.iterator();
            for (String expectedLine : expectedLines) {
                String line = it.next();
                if (line.equals(expectedLine)) continue;
                result = false;
                break;
            }
        } else {
            result = false;
        }
        return result;
    }
}

